/* Ein DataSpecification-Template gemäß IEC61360 zur Beschreibung der Semantik anlegen */
DataSpecificationIEC61360 dataSpec;
dataSpec.setPreferredName("Größe der Werkzeugaufnahme");
dataSpec.setDataType("String");
dataSpec.setDefinition(
    "Angabe über die Größe der Verbindungsstelle zur Kraftübertragung "
    "zwischen Werkzeug und Maschine in Millimeter");
/* Eine ConceptDescription zur Beschreibung der Eigenschaft "Werkzeugaufnahme" erstellen und die DataSpecification zuweisen */
ConceptDescription toolSizeDescription;
toolSizeDescription.setIdentification(Identifier(Identifier::IdentifierType::IRDI, "0173-1#02-AAI027#0005"));
toolSizeDescription.setIdShort("ToolInsertionSize");
toolSizeDescription.addDataSpecification(dataSpec);
/* Ein Property vom Typ String erstellen, das die ConceptDescription referenziert */
Property<std::string> toolSize;
toolSize.setIdShort("ToolInsertionSize");
toolSize.setSemanticId(Reference::FromIdentifiable(Key::KeyElements::ConceptDictionary, true, toolSizeDescription));
toolSize.setValue("3 / 8 inch external square");
toolSize.setValueId("0173-1#02-AAI027#0001");
