﻿using Microsoft.JSInterop;
using System.Threading.Tasks;

namespace ITVisions.Blazor
{
 partial class BlazorUtil
 {

  public async Task<bool> SetCookie(string name, object value, bool endless = false)
  {
   if (_jsRuntime == null) return false;
   var cookie = name + "=" + value + @";path=/";
   if (endless) cookie += "; expires = Fri, 31 Dec 9999 23:59:59 GMT";
   return await _jsRuntime.InvokeAsync<bool>("setCookie", cookie);
  }

  public async Task<bool> RemoveCookie(string name)
  {
   if (_jsRuntime == null) return false;
   var cookie = name + "=" + "" + @";path=/";
   cookie += "; expires = Fri, 31 Dec 1970 23:59:59 GMT";
   return await _jsRuntime.InvokeAsync<bool>("setCookie", cookie);
  }

  public async Task<string> GetCookie(string name)
  {
   var dic = await GetCookies();
   if (!dic.ContainsKey(name)) return null;
   return dic[name];
  }
 }
}
