﻿using Microsoft.AspNetCore.Http.Features;
using System;
using System.Collections.Generic;
using System.Text;

namespace ITVisions.Blazor
{
 partial class BlazorUtil
 {
  public Version GetAppVersion()
  {
   return System.Reflection.Assembly.GetExecutingAssembly().GetName().Version;
  }

  public string GetAppVersionShort()
  {
   return System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.Major + "." + System.Reflection.Assembly.GetExecutingAssembly().GetName().Version.Minor;
  }

  public string GetBrowserInfo()
  {
   if (httpContextAccessor == null) return null;
   try
   {
    return httpContextAccessor.HttpContext.Request.Headers["User-Agent"];
   }
   catch (Exception)
   {
    return "n/a";
   }
  }

  public bool IsInternetExplorer()
  {
   if (httpContextAccessor == null) return false;
   return GetBrowserInfo().ToUpper().Contains("MSIE");
  }

  public string GetClientIP()
  {
   if (httpContextAccessor == null) return null;
   try
   {
    return httpContextAccessor.HttpContext.Connection.RemoteIpAddress.ToString();
   }
   catch (Exception)
   {
    return "n/a";
   }
  }

  public string GetServerIP()
  {
   if (httpContextAccessor == null) return null;
   try
   {
    return httpContextAccessor.HttpContext.Features.Get<IHttpConnectionFeature>()?.LocalIpAddress.ToString();
   }
   catch (Exception)
   {
    return "n/a";
   }
  }
 }
}
