﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.SignalR;
using BL;

namespace MiracleList_Backend.Hubs
{

 public class MLHub : Hub
 {

  public async Task Register(string user)
  {
   new BL.LogManager().Log(BO.Event.Call, BO.Severity.Information, "User=" + user, nameof(Register));
   await Groups.AddToGroupAsync(Context.ConnectionId, user);
  }

  public async Task SendCategoryListUpdate(string user)
  {
   new BL.LogManager().Log(BO.Event.Call, BO.Severity.Information, "User=" + user, nameof(SendCategoryListUpdate));
   // Sende Benachrichtigung an die ganze Gruppe
   await Clients.Groups(user).SendAsync("CategoryListUpdate", Context.ConnectionId);
   // oder an alle: await Clients.All.SendAsync("CategoryListUpdate", Context.ConnectionId);
  }

  public async Task SendTaskListUpdate(string user, int categoryID)
  {
   new BL.LogManager().Log(BO.Event.Call, BO.Severity.Information, "User=" + user + "Category=" + categoryID, nameof(SendTaskListUpdate));
   // Sende Benachrichtigung an die ganze Gruppe
   await Clients.Groups(user).SendAsync("TaskListUpdate", Context.ConnectionId, categoryID);
  }
 }
}