﻿using Microsoft.AspNetCore.SignalR;
using System.Threading.Tasks;

namespace MiracleList_Backend.Hubs
{
 /// <summary>
 /// ASP.NET Core SignalR Hub
 /// </summary>
 public class MLHub : Hub
 {
  public async Task Register(string user)
  {
   await Groups.AddToGroupAsync(Context.ConnectionId, user);
  }

  public async Task SendCategoryListUpdate(string user)
  {
   // Sende Benachrichtigung an die ganze Gruppe
   await Clients.Groups(user).SendAsync("CategoryListUpdate", Context.ConnectionId);
   await Clients.All.SendAsync("CategoryListUpdate", user);

  }

  public async Task SendTaskListUpdate(string user, int categoryID)
  {
   // Sende Benachrichtigung an die ganze Gruppe
   await Clients.Groups(user).SendAsync("TaskListUpdate", Context.ConnectionId, categoryID);
  }
 }
}