using ITVisions.Blazor;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Authorization;
using System;
using System.Linq;
using System.Security.Claims;
using System.Threading.Tasks;

namespace Web.Pages
{
 public partial class TaskEdit
 {

  [Parameter]
  public BO.Task Task { get; set; }

  [Parameter]
  public EventCallback<int> TaskHasChanged { get; set; }

  int userID = 0;

  [Inject]
  BlazorUtil Util { get; set; } = null;

  [CascadingParameter] Task<AuthenticationState> authenticationStateTask { get; set; }

  protected async override System.Threading.Tasks.Task OnInitializedAsync()
  {
   var u = (await authenticationStateTask).User;
   userID = Convert.ToInt32(u.Claims.FirstOrDefault(x => x.Type == ClaimTypes.Sid).Value);
   Util.Log(nameof(TaskEdit) + "." + nameof(OnInitialized) + ": " + Task.TaskID + " of user " + userID);
  }

  // wird gefeuert, wenn Parameter gesetzt wurden
  protected override void OnParametersSet()
  {
   Util.Log((nameof(OnParametersSet) + ": " + Task.TaskID));
  }

  protected void Save()
  {
   Util.Log(nameof(Save) + ": " + Task.TaskID);
   Util.Log(this.Task);
   new BL.TaskManager(userID).ChangeTask(this.Task);
   TaskHasChanged.InvokeAsync(Task.TaskID);
  }

  protected void Cancel()
  {
   Util.Log(nameof(Cancel) + ": " + Task.TaskID);
   TaskHasChanged.InvokeAsync(Task.TaskID);
  }
 }
}