﻿//Praxishinweis: Der Datenzugriffscode liegt in der Praxis in unteren Schichten, also getrennten Assemblies. Er ist hier nur aus Gründen der Prägnanz und Übersichtlichkeit des Beispiels in der Code-Behind-Datei direkt enthalten.

using DAL;
using Microsoft.EntityFrameworkCore;
using System;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;

namespace WWWingsWebforms
{
 public partial class Fluege : System.Web.UI.Page
 {
  public int Anzahl = 0;
  public string Info = "";
  int skip = 0;
  int take = 10;

  protected void Page_Load(object sender, EventArgs e)
  {

   Info = "<b>Browser:</b> " + HttpContext.Current.Request.Browser.Browser + " " + HttpContext.Current.Request.Browser.Version + "<br><b>Server:</b> " + HttpContext.Current.Request.ServerVariables["SERVER_SOFTWARE"] + " mit " + System.Runtime.InteropServices.RuntimeInformation.FrameworkDescription;

   if (!Page.IsPostBack)
   {
    AbflugorteLaden();
   }
  }

  protected void C_Abflugort_SelectedIndexChanged(object sender, EventArgs e)
  {
   ZielorteLaden();
  }

  protected void C_Zielort_SelectedIndexChanged(object sender, EventArgs e)
  {
   FluegeLaden();
  }

  protected void AbflugorteLaden()
  {
   using (var ctx = new DAL.Wwwings66_VieledatenContext())
   {
    this.C_Abflugort.DataSource = ctx.Flug.Select(x => x.Abflugort).Distinct().OrderBy(x => x).ToList();
    this.C_Abflugort.SelectedValue = "Berlin";
    this.C_Abflugort.DataBind();
    ZielorteLaden();
   }
  }

  private void ZielorteLaden()
  {
   using (var ctx = new DAL.Wwwings66_VieledatenContext())
   {
    this.C_Zielort.DataSource = ctx.Flug.Where(x => x.Abflugort == this.C_Abflugort.SelectedValue).Select(x => x.Zielort).Distinct().OrderBy(x => x).ToList();
    this.C_Zielort.DataBind();
   }
   FluegeLaden();
  }

  protected void FluegeLaden()
  {
   using (var ctx = new DAL.Wwwings66_VieledatenContext())
   {
    var flugSet = ctx.Flug.Where(x => x.Abflugort == this.C_Abflugort.SelectedValue && x.Zielort == this.C_Zielort.SelectedValue && x.FreiePlaetze > 0).Skip(skip).Take(take).OrderBy(x => x.Datum).ToList();
    Anzahl = flugSet.Count;
    C_Fluege.DataSource = flugSet;
    C_Fluege.DataBind();
   }

  }

  protected void C_Loeschen_Click(object sender, System.Web.UI.ImageClickEventArgs e)
  {
   using (var ctx = new DAL.Wwwings66_VieledatenContext())
   {
    ImageButton button = sender as ImageButton;
    int flugNr = Convert.ToInt32(button.CommandArgument);
    int countBuchungen = ctx.Database.ExecuteSqlRaw("delete from betrieb.Flug_Passagier where Flug_FlugNr ={0}", flugNr);
    ctx.Remove(ctx.Flug.Find(flugNr));
    int countFluege = ctx.SaveChanges();
   }
   FluegeLaden();
  }
 }
}

