# MiracleListBackend
Source code for the MiracleList-Backend (https://miraclelistbackend.azurewebsites.net)
and the Blazor-based implementations of the MiracleList-Clients

URLs to the Live-Systems:
- Angular-based Frontend: http://miraclelist.azurewebsites.net
- Blazor-Server-based Frontend: http://miraclelist-BlazorServer.azurewebsites.net
- Blazor-Webassembly-based Frontend: http://miraclelist-Blazor-Webassembly.azurewebsites.net
- Backend: http://miraclelistbackend.azurewebsites.net

Used frameworks and tools:
- .NET Core 3.1	with C# 				
- Entity Framework Core 2.2			
- SQL Azure
- ASP.NET Core WebAPI 3.1
- ASP.NET Core Blazor Server 3.1
- ASP.NET Core Blazor Webassembly 3.2-Preview
- Application Insights
- Swagger/Swashbuckle.AspNetCore		
- HTTP tests with Postman

Create the database:
- Change connection string in: DAL/Context.cs
- Set as Startup Project: EFCTools
- Package Manager Console: Default Project = DAL
- Package Manager Console: Run: Update-Database

Execute Unit Tests:
- use Test Explorer

Test the Website:
- View in Browser (STRG SHIFT W)
- http://localhost:8887/index.html

Important NuGet Packages:
- BO:
Install-Package System.ComponentModel.Annotations
- DAL and BL:
Install-Package Microsoft.EntityFrameworkCore.SqlServer
- Web:
Install-Package Microsoft.AspNet.Cors
Install-Package Swashbuckle.AspNetCore

#News
- v0.18: Update auf Blazor WebAssembly 3.2 Preview 2, +Cookies in Blazor
- v0.17: Update auf Blazor WebAssembly 3.2 Preview 2
- v0.16: +ASP.NET SignalR for Notifications of changes of tasks (new, edited, removed) in one category