﻿// ITVBlazorRCL 
// JavaScript Ultities for Blazor
// (C) Dr. Holger Schwichtenberg 2019-2020

window.log = (s) => {
 console.log(s);
};

window.ShowAlert = (text) => {
 console.log("ShowAlert", text);
 alert(text);
 return true; // TODO: return entfernen
};

function ShowConfirm(text1, text2) {
 console.log("ShowConfirm", text1, text2);
 return confirm(text1 + "\n" + text2);
}

function SetTitle(text) {
 console.log("SetTitle", text);
 window.document.title = text;
}

window.Util = {
 focusElement: function (element) {
  element.focus();
 },

 GetBrowserInfo: function (element, assembly, method) {
  DotNet.invokeMethodAsync(assembly, method) // Assembly, Methode
   .then(data => {
    data.push("Information from JavaScript:");
    data.push("Browser Type: " + navigator.appCodeName);
    data.push("Browser Version: " + navigator.appVersion);
    element.value = data.join("\n");
   });
 }
};

document.addEventListener("DOMContentLoaded", function () {
 console.log("DOMContentLoaded");
 document.addEventListener('resize', ScreenInfo);
 ScreenInfo();
});

window.ScreenInfo = () => {
 console.log("resize");
 if (!document.getElementById('clientW')) return;
 console.log("ScreenInfo");
 document.getElementById('clientW').textContent = document.querySelector('html').clientWidth;
 document.getElementById('innerW').textContent = window.innerWidth;
 document.getElementById('outerW').textContent = window.outerWidth;
 document.getElementById('clientH').textContent = document.querySelector('html').clientHeight;
 document.getElementById('innerH').textContent = window.innerHeight;
 document.getElementById('outerH').textContent = window.outerHeight;
 document.getElementById('screenW').textContent = screen.width;
 document.getElementById('availW').textContent = screen.availWidth;
 document.getElementById('screenH').textContent = screen.height;
 document.getElementById('availH').textContent = screen.availHeight;
};


//calcSizeInfo(width)
//{
// let size = width;
// let sizeName = "";

// switch (true) {
//  case (size >= 1170): sizeName = "lg"; break;
//  case (size >= 970): sizeName = "md"; break;
//  case (size >= 750): sizeName = "sm"; break;
//  default: sizeName = "xs"; break;
// }

// this.sizeInfo = size + "px (" + sizeName + ")";
//}

window.setCookie = (cookie) => {
 document.cookie = cookie;
 return true;
};

window.getCookie = () => {
 return document.cookie;
};

console.log(document.currentScript + " loaded.");