﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Fluege.aspx.cs" Inherits="WWWingsWebforms.Fluege" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
 <title>WWWings - Webforms</title>
</head>
<body>

 <style>
  body { font-family: sans-serif }

  input[type=checkbox] {
   /* Double-sized Checkboxes */
   -ms-transform: scale(2); /* IE */
   -moz-transform: scale(2); /* FF */
   -webkit-transform: scale(2); /* Safari and Chrome */
   -o-transform: scale(2); /* Opera */
   transform: scale(2);
   padding: 10px;
  }
 </style>

 <a href="http://www.world-wide-wings.de">
  <img width="200" style="margin-right: 20px;" align="left" src="/content/WorldWideWings_Logo.jpg" />
 </a>

 <h3 style="padding-bottom:40px">ASP.NET 4.8 Webforms</h3>

 <hr />
 <form id="form1" runat="server">

  <h4>von:
   <asp:DropDownList ID="C_Abflugort" runat="server" AutoPostBack="True" OnSelectedIndexChanged="C_Abflugort_SelectedIndexChanged"></asp:DropDownList>
   &nbsp;nach:
   <asp:DropDownList ID="C_Zielort" runat="server" AutoPostBack="True" OnSelectedIndexChanged="C_Zielort_SelectedIndexChanged"></asp:DropDownList>
   <%= Anzahl %> Flüge gefunden</h4>

  <hr />
  <asp:GridView AutoGenerateColumns="False" ID="C_Fluege" runat="server" CellPadding="4" ForeColor="#333333" GridLines="None">
   <AlternatingRowStyle BackColor="White" />
   <HeaderStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" />
   <RowStyle BackColor="#EFF3FB" />

   <Columns>
    <asp:BoundField HeaderText="Flug-Nr" DataField="FlugNr" />
    <asp:BoundField HeaderText="Abflugort" DataField="Abflugort" />
    <asp:BoundField HeaderText="Zielort" DataField="Zielort" />
    <asp:BoundField HeaderText="Datum" DataField="Datum" DataFormatString="{0:d}" />
    <asp:CheckBoxField HeaderText="Nichtraucher" DataField="NichtRaucherFlug">
     <ItemStyle HorizontalAlign="Center" />
    </asp:CheckBoxField>

    <asp:TemplateField HeaderText="Auslastung">
     <ItemTemplate>
      <div><%# Eval("FreiePlaetze")%> freie Plätze</div>
      <div style="<%# "font-size: smaller;" + (Convert.ToDecimal(Eval("PlatzAuslastung")) > 50 ? "color:red": "color:green") %>">
       (<%# String.Format("{0:00.00}",Eval("PlatzAuslastung")) %>%)
      </div>
     </ItemTemplate>
    </asp:TemplateField>

    <asp:TemplateField ShowHeader="False">
     <ItemTemplate>
      <asp:ImageButton ID="C_Loeschen" CommandArgument='<%#Eval("FlugNr")%>' runat="server" Width="20px" ImageUrl="~/img/delete.png"
       CommandName="C_Loeschen" OnClientClick="return confirm('Möchten Sie diesen Flug wirklich entfernen?');" OnClick="C_Loeschen_Click"
       AlternateText="Flug löschen" />
     </ItemTemplate>
    </asp:TemplateField>

   </Columns>
  </asp:GridView>
  <hr />
  <%=Info %>
  <hr>
  <%="WWWings " + typeof(ASPNETWebforms.RouteConfig).Assembly.GetName().Version.ToString()%>
 </form>
</body>
</html>
