﻿//Praxishinweis: Der Datenzugriffscode liegt in der Praxis in unteren Schichten, also getrennten Assemblies. Er ist hier nur aus Gründen der Prägnanz und Übersichtlichkeit des Beispiels in der Code-Behind-Datei direkt enthalten.

using DAL;
using DevExpress.Blazor;
using Microsoft.AspNetCore.Components;
using Microsoft.AspNetCore.Components.Web;
using Microsoft.AspNetCore.Http;
using Microsoft.EntityFrameworkCore;
using Microsoft.JSInterop;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace WWWingsBlazorDevExpress.Pages
{

 public partial class Fluege
 {
  #region DI
  [Inject]
  IHttpContextAccessor httpContextAccessor { get; set; }
  [Inject]
  IJSRuntime _jsRuntime { get; set; }
  #endregion

  #region Properties
  List<Flug> flugSet { get; set; } = new List<Flug>();
  string info = "";
  string c_abflugort = "London";
  string C_Abflugort
  {
   get
   { return this.c_abflugort; }
   set
   { this.c_abflugort = value; ZielorteLaden(); InvokeAsync(StateHasChanged); }
  }
  string c_zielort = null;
  string C_Zielort
  {
   get
   { return this.c_zielort; }
   set
   {
    this.c_zielort = value; FluegeLaden(); InvokeAsync(StateHasChanged);
   }
  }
  List<string> Abflugorte = new List<string>();
  List<string> Zielorte = new List<string>();
  int Anzahl = 10;
  int skip = 0;
  int take = 100;
  #endregion

  protected override void OnInitialized()
  {
   var httpContext = httpContextAccessor.HttpContext;
   info = "<b>Browser:</b> " + httpContext.Request.Headers["User-Agent"] + "<br><b>Server</b>: " + httpContext.GetServerVariable("SERVER_SOFTWARE") + " mit " + System.Runtime.InteropServices.RuntimeInformation.FrameworkDescription + "<br><b>DevExpress Blazor</b>: " + typeof(DevExpress.Blazor.DxButton).Assembly.GetName().Version;

   AbflugorteLaden();
  }

  protected void AbflugorteLaden()
  {
   using (var ctx = new DAL.Wwwings66_VieledatenContext())
   {
    this.Abflugorte = ctx.Flug.Select(x => x.Abflugort).Distinct().OrderBy(x => x).ToList();
    this.C_Abflugort = "Berlin";
    ZielorteLaden();
   }
  }

  private void ZielorteLaden()
  {
   using (var ctx = new DAL.Wwwings66_VieledatenContext())
   {
    this.Zielorte = ctx.Flug.Where(x => x.Abflugort == this.C_Abflugort).Select(x => x.Zielort).Distinct().OrderBy(x => x).ToList();
    //this.C_Zielort = this.Zielorte.ElementAt(0);
   }
   FluegeLaden();
  }

  protected void FluegeLaden()
  {
   using (var ctx = new DAL.Wwwings66_VieledatenContext())
   {
    flugSet = ctx.Flug.Where(x => x.Abflugort == this.C_Abflugort && (!string.IsNullOrEmpty(this.C_Zielort) ? x.Zielort == this.C_Zielort : true) && x.FreiePlaetze > 0).Skip(skip).Take(take).OrderBy(x => x.Datum).ToList();
    Anzahl = flugSet.Count;
   }
  }

  void OnHtmlRowDecoration(DataGridHtmlRowDecorationEventArgs<Flug> eventArgs)
  {
   if (eventArgs.VisibleIndex % 2 == 1)
    eventArgs.CssClass = "rowOdd";
   else
    eventArgs.CssClass = "rowEven";

  }

  protected async Task C_Loeschen_Click(int flugNr)
  {

   // Aufruf von confirm() in JavaScript
   var e = await _jsRuntime.InvokeAsync<bool>("confirm", $"Möchten Sie den Flug {flugNr} wirklich entfernen?");
   if (!e) return;

   using (var ctx = new DAL.Wwwings66_VieledatenContext())
   {
    // erst alle Passagiere entfernen
    int countBuchungen = ctx.Database.ExecuteSqlRaw("delete from betrieb.Flug_Passagier where Flug_FlugNr ={0}", flugNr);
    ctx.Remove(ctx.Flug.Find(flugNr));
    int countFluege = ctx.SaveChanges();

    await _jsRuntime.InvokeVoidAsync("alert", $"Gelöschte Flüge: {countFluege}\nGelöschte Buchungen: {countBuchungen}");
   }
   FluegeLaden();
  }
 }
}
