package de.ix.lack;

import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;

public class ColorConverter implements Converter<String, float[]> {
    @Override
    public Result<float[]> convertToModel(String value, ValueContext context) {
        try {
            return Result.ok(convertStringColor(value));
        } catch (NumberFormatException | NullPointerException e) {
            return Result.error("Kein Farbwert.");
        }
    }

    @Override
    public String convertToPresentation(float[] value, ValueContext context) {
        return convertFloatColor(value);
    }

    public static float[] convertStringColor(String value) {
        int i = Integer.parseInt(value.substring(1), 16);
        return new float[] {((i>>>16)&0xff)/255.0f, ((i>>>8)&0xff)/255.0f, (i&0xff)/255.0f };
    }

    public static String convertFloatColor(float[] value) {
        return '#' +String.format("%06X", (color(value[0])<<16 | color(value[1])<<8 | color(value[2])));
    }

    private static int color(float c) {
        return (int)(c * 255.0f);
    }
}
