package de.ix.lack;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;

@Service
public class LackService implements Serializable {

    private static final TypeReference<List<DataModel>> typeRef = new TypeReference<List<DataModel>>() {};

    private final ObjectMapper objectMapper = new ObjectMapper();

    @Value("${:classpath:models.json}")
    private Resource presets;

    private DataModel dataModel = new DataModel();

    private List<DataModel> dataModelPresets;

    @PostConstruct
    private void setup() throws IOException {
        dataModelPresets = objectMapper.readValue(presets.getInputStream(), typeRef);
    }

    public DataModel readDataModel() {
        return dataModel;
    }

    public String convertModelAsJson(DataModel model) {
        try {
            return objectMapper.writeValueAsString(model);
        } catch (JsonProcessingException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeDataModel(DataModel dataModel) {
        this.dataModel = dataModel;
    }

    public List<DataModel> selectDataModelPresets() {
        return Collections.unmodifiableList(dataModelPresets);
    }
}
