package de.ix.lack;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;

/**
 * https://www.webcomponents.org/element/@polymer/paper-swatch-picker
 */
@Tag("paper-swatch-picker")
@NpmPackage(value = "@polymer/paper-swatch-picker", version = "3.0.1")
@JsModule("@polymer/paper-swatch-picker/paper-swatch-picker.js")
public class PaperSwatch extends AbstractSinglePropertyField<PaperSwatch, String> {

    /**
     * Polymer paper swatch constructor.
     * @param htmlColorCode initial value
     */
    public PaperSwatch(String htmlColorCode) {
        super("color", htmlColorCode, false);
    }
}