package de.ix.lack;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.router.Route;
import org.springframework.beans.factory.annotation.Autowired;

@Route("lack")
@CssImport("./styles/shared-styles.css")
public class LackView extends Composite<Div> {

    private final DataModelComponent component;
    private final LackService service;

    /**
     * Erstellt den Editor für das Modell.
     *
     * @param service der spring service
     */
    @Autowired
    public LackView(DataModelComponent component, LackService service) {
        this.component = component;
        this.service = service;

        component.setEntity(service.readDataModel());

        Select<DataModel> selection = new Select<>();
        selection.setItems(service.selectDataModelPresets());
        selection.setTextRenderer(DataModel::getName);
        selection.addValueChangeListener(this::selectionChanged);

        getContent().add(selection, component);
    }

    private void selectionChanged(AbstractField.ComponentValueChangeEvent<Select<DataModel>, DataModel> e) {
        service.writeDataModel(e.getValue());
        component.setEntity(e.getValue());
    }
}
