package de.ix.lack;

import com.vaadin.flow.component.AbstractSinglePropertyField;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;

/**
 * Google Polymer Paper Slider.
 * See e.g. https://vaadin.com/forum/thread/18215247/vaadin-14-slider
 */
@Tag("paper-slider")
@NpmPackage(value = "@polymer/paper-slider", version = "3.0.1")
@JsModule("@polymer/paper-slider/paper-slider.js")
public class PaperSlider extends AbstractSinglePropertyField<PaperSlider, Integer> {

    public PaperSlider(int maximum) {
        super("value", 0, false);
        Element element = getElement();
        element.setProperty("pin", true);
        element.setProperty("max", maximum);
    }
}