package de.ix.lack;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;

/**
 * Kleine Komponente zur Darstellung der Lack-Eigenschaften.
 */
@Tag("canvas")
public class Raytrace extends Component  {

    private final String id = "unique";

    public Raytrace() {
        Element element = getElement();
        element.setAttribute("id", id);
        element.setAttribute("width", "500");
        element.setAttribute("height", "500");
        element.setAttribute("class", "rt");
        element.setText("Ihr Browser unterstützt kein HTML5.");
    }

    @Override
    protected void onAttach(AttachEvent attachEvent) {
        attachEvent.getUI().getPage().addJavaScript("/src/sphere.js");
    }

    public void repaint(String jsonDataModel) {

        UI.getCurrent().getPage().executeJs("Sphere.setDataModel($0, $1);", id, jsonDataModel);
    }
}
