﻿// File-Scoped Namespace
namespace Heise.iX;

// record class ist gleichbedeutend mit record
public record class Firma {
 public string Name { get; set; }
 public Firma(string name)
 {
  this.Name = name;
 }
 public override sealed string ToString() => this.Name;
}

// Readonly Record Struct auf dem Stack mit Primärkonstruktor
public readonly record struct Autor(int ID,
                                    string? Name,
                                    int ArtikelAnzahl = 0)
{
 // Zusätzliche Properties müssen Init-Only-Setter besitzen, da Struktur readonly ist
 // Zudem Initialisierungspflicht - außer für Strukturen (hier: DateOnly)
 public int Alter { get; init; } = 0;
 public readonly string Wohnort { get; init; } = "";
 public List<Firma> Firmen { get; init; } = new();
 public DateOnly ErsterBeitrag { get; init; }

 // Methode mit Caller Argument Expression
 public void Check(
    int yearMin,
    int yearMax,
    [SRC.CallerArgumentExpression("yearMin")] string? yearMinExpression = null,
    [SRC.CallerArgumentExpression("yearMax")] string? yearMaxExpression = null)
 {
  if (ErsterBeitrag.Year < yearMin || ErsterBeitrag.Year > yearMax)
  {
   throw new ArgumentOutOfRangeException(nameof(ErsterBeitrag),
     $"{ErsterBeitrag} muss zwischen {yearMin} ({yearMinExpression}) und {yearMax} ({yearMaxExpression}) liegen!");
  }
 }
}