﻿// Top-Level-Statements (C# 9) + static using (C# 6) + global using (C# 10)
WriteLine("C# 10 im Einsatz");

// Constant interpolated Strings
const string Vorname = "Holger";
const string Nachname = "Schwichtenberg";
const string GanzerName = $"Dr. {Vorname} {Nachname}";

// Variable für Readonly Record Struct deklarieren
Autor hs;
// Readonly Record Struct instanzieren
hs = new(42, GanzerName, 192)
        {
         ErsterBeitrag = new DateOnly(1998, 9, 7),
         Alter = 49,
         Wohnort = "Essen",
         Firmen = new List<Firma> { new Firma("MAXIMAGO GmbH"), new Firma("www.IT-Visions.de")}
        };

// nicht möglich,weil readonly: hs.ArtikelAnzahl++;
// daher: veränderten Klon erstellen
var hsKlon = hs with { ArtikelAnzahl = hs.ArtikelAnzahl + 1 };
WriteLine(hsKlon);

// Aufruf einer Methode, die Caller Argument Expressions besitzt
hsKlon.Check(1988, DateTime.Now.Year);

// Extended Property Pattern
object o = hsKlon;
if (o is Autor { ErsterBeitrag.Year: 1998 })
{
 WriteLine("Jahr des ersten iX-Artikels dieses Autors stimmt!");
}

// Mixed Deconstruction: Reine Zuweisung an bestehende Variable sowie Inline-Deklaration + Zuweisung vermischt
int id;
(id, string? name, _) = hsKlon;
// Einzelne Variablen verwenden
WriteLine($"Autor #{id}: {name ?? "KEIN NAME"}");

// Funktion via Lambda mit Typherleitung deklarieren
var status = (Autor a) => $"{a.Name ?? "KEIN NAME"} hat {a.ArtikelAnzahl} geschrieben!";
// Funktion verwenden
WriteLine(status(hsKlon));