async function setupCapture() {...}

function setupROI(frame, trackWindow) {...}

function drawRect(trackBox, frame) {...}

function onOpenCvReady() {
  cv['onRuntimeInitialized'] = async () => {
    const FPS = 30;

    let hsv = new cv.Mat(video.height, video.width, cv.CV_8UC3);
    let hsvVec = new cv.MatVector();
    hsvVec.push_back(hsv);
    let dst = new cv.Mat();
    let trackBox = null;
    let trackWindow = new cv.Rect(150, 60, 63, 125);
    let termCrit = new cv.TermCriteria(
      cv.TERM_CRITERIA_EPS | cv.TERM_CRITERIA_COUNT,
      10,
      1
    );

    const { video, cap, frame } = await setupCapture();
    let roiHist = setupROI(frame, trackWindow);

    function processVideo() {
      try {
        let begin = Date.now();

        cap.read(frame);
        cv.cvtColor(frame, hsv, cv.COLOR_RGBA2RGB);
        cv.cvtColor(hsv, hsv, cv.COLOR_RGB2HSV);
        cv.calcBackProject(hsvVec, [0], roiHist, dst, [0, 180], 1);

        [trackBox, trackWindow] = cv.CamShift(dst, trackWindow, termCrit);

        drawRect(trackBox, frame);
        cv.imshow('canvasOutput', frame);

        let delay = 1000 / FPS - (Date.now() - begin);
        setTimeout(processVideo, delay);
      } catch (err) {
        utils.printError(err);
      }
    }

    setTimeout(processVideo, 0);
  };
}