console.time('template matching');

function loadImage(imageFile) {
  return new Promise((resolve) => {
    const image = new Image();
    image.src = imageFile;
    image.onload = () => resolve(image);
  });
}

function onOpenCvReady() {
  cv['onRuntimeInitialized'] = async () => {
    const [stein, steine] = await Promise.all([
      loadImage('./Stein.jpg'),
      loadImage('./Steine.jpg'),
    ]);

    document.getElementById('stein').getContext('2d').drawImage(stein, 0, 0);
    document.getElementById('steine').getContext('2d').drawImage(steine, 0, 0);

    const source = cv.imread('steine');
    const template = cv.imread('stein');
    const dst = new cv.Mat();
    const mask = new cv.Mat();

    cv.matchTemplate(source, template, dst, cv.TM_CCOEFF, mask);
    const { maxLoc: maxPoint } = cv.minMaxLoc(dst, mask);

    let color = new cv.Scalar(255, 0, 0, 255);
    let point = new cv.Point(
      maxPoint.x + template.cols,
      maxPoint.y + template.rows
    );
    cv.rectangle(source, maxPoint, point, color, 2, cv.LINE_8, 0);
    cv.imshow('steine', source);
    console.timeEnd('template matching');
  };
}
