import data from '$lib/laureates.json';
import { commentStore } from '$lib/stores.js';

/**
 * @param {string} query
 */
export function search(query) {
	const queryRegex = new RegExp(query, 'ig');

	const results = data.laureates.filter(
		(item) => queryRegex.test(item.firstname) || queryRegex.test(item.surname ?? '')
	);

	return commentify(results);
}

/**
 * @param {string} id
 */
export function getProfile(id) {
	const laureate = data.laureates.find((item) => item.id === id);

	const withComments = commentify([laureate])[0];

	return withComments;
}

/**
 * @param {{comments: string[]; id: string;}[]} results
 */
function commentify(results) {
	return results.map((result) => {
		const comments = commentStore.get(result.id);

		if (comments) {
			result.comments = comments;
		}

		return result;
	});
}
