import { useEffect, useState } from 'react';

let lastUpdate = 0;
const interval = 20;

export default function TemperatureThrottle() {
  const [temp, setTemp] = useState(0);

  useEffect(() => {
    const socket = new WebSocket('ws://localhost:3001');
    socket.addEventListener('message', (event) => {
      const eventData = JSON.parse(event.data);
      const now = Date.now();
      if (now - lastUpdate >= interval) {
        lastUpdate = now;
        setTemp(eventData.value);
      }
      if (eventData.sequence > 100) {
        socket.close();
      }
    });
    return () => {
      socket.close();
    };
  }, []);

  return <div>Temperatur: {temp}°C</div>;
}
