import { useEffect, useState } from 'react';

export default function Temperature() {
  const [temp, setTemp] = useState(0);

  useEffect(() => {
    const socket = new WebSocket('ws://localhost:3001');
    socket.addEventListener('message', (event) => {
      const { value } = JSON.parse(event.data);
      setTemp(value);
    });
    return () => {
      socket.close();
    };
  }, []);

  return <div>Temperatur: {temp}°C</div>;
}
