import { useEffect, useState } from 'react';
import { calc } from './util';

export default function TemperatureCalc() {
  const [temp, setTemp] = useState(0);

  useEffect(() => {
    const socket = new WebSocket('ws://localhost:3001');
    socket.addEventListener('message', (event) => {
      const eventData = JSON.parse(event.data);
      calc();
      setTemp(eventData.value);
      if (eventData.sequence > 100) {
        socket.close();
      }
    });
    return () => {
      socket.close();
    };
  }, []);

  return <div>Temperatur: {temp}°C</div>;
}
