import { useEffect, useState } from 'react';

export default function TemperatureWorker() {
  const [temp, setTemp] = useState(0);

  useEffect(() => {
    const worker = new Worker('./worker.js', { type: 'module' });

    worker.onmessage = (event) => {
      const eventData = JSON.parse(event.data);
      setTemp(eventData.value);
    };
    return () => {
      worker.terminate();
    };
  }, []);

  return <div>Temperatur: {temp}°C</div>;
}
