import { useEffect, useState } from 'react';

export default function DataTable() {
  const [items, setItems] = useState([]);

  useEffect(() => {
    const socket = new WebSocket('ws://localhost:3001');
    socket.addEventListener('message', (event) => {
      const eventData = JSON.parse(event.data);
      if (Array.isArray(eventData)) {
        setItems(eventData);
      } else {
        setItems((prevItems) => {
          return prevItems.map((item) => {
            if (item.id === eventData.id) {
              return eventData;
            } else {
              return item;
            }
          });
        });
      }
    });
  }, []);

  return (
    <table>
      <thead>
        <tr>
          <th>id</th>
          <th>price</th>
          <th>inStock</th>
          <th>serialNumber</th>
          <th>discount</th>
          <th>ordered</th>
          <th>height</th>
          <th>width</th>
          <th>weight</th>
        </tr>
      </thead>
      <tbody>
        {items.map((item) => (
          <tr key={item.id}>
            <th>{item.id}</th>
            <th>{item.price}</th>
            <th>{item.inStock}</th>
            <th>{item.serialNumber}</th>
            <th>{item.discount}</th>
            <th>{item.ordered}</th>
            <th>{item.height}</th>
            <th>{item.width}</th>
            <th>{item.weight}</th>
          </tr>
        ))}
      </tbody>
    </table>
  );
}
