import { useState, useEffect } from 'react';
import { FixedSizeList } from 'react-window';

function Table({ children, style }) {
  return (
    <table>
      <thead>
        <tr>
          <th style={{ width: 50 }}>id</th>
          <th style={{ width: 200 }}>price</th>
          <th style={{ width: 200 }}>inStock</th>
          <th style={{ width: 200 }}>serialNumber</th>
          <th style={{ width: 200 }}>discount</th>
          <th style={{ width: 200 }}>ordered</th>
          <th style={{ width: 200 }}>height</th>
          <th style={{ width: 200 }}>width</th>
          <th style={{ width: 200 }}>weight</th>
        </tr>
      </thead>
      <tbody style={{ ...style, position: 'absolute', width: '100%' }}>
        {children}
      </tbody>
    </table>
  );
}

export default function DataTableWindow() {
  const [items, setItems] = useState([]);

  useEffect(() => {
    const socket = new WebSocket('ws://localhost:3001');
    socket.addEventListener('message', (event) => {
      const eventData = JSON.parse(event.data);
      if (Array.isArray(eventData)) {
        setItems(eventData);
      } else {
        setItems((prevItems) => {
          return prevItems.map((item) => {
            if (item.id === eventData.id) {
              return eventData;
            } else {
              return item;
            }
          });
        });
      }
    });
  }, []);

  function Row({ index, style }) {
    return (
      <tr style={style}>
        <th style={{ width: 50 }}>{items[index].id}</th>
        <th style={{ width: 200 }}>{items[index].price}</th>
        <th style={{ width: 200 }}>{items[index].inStock}</th>
        <th style={{ width: 200 }}>{items[index].serialNumber}</th>
        <th style={{ width: 200 }}>{items[index].discount}</th>
        <th style={{ width: 200 }}>{items[index].ordered}</th>
        <th style={{ width: 200 }}>{items[index].height}</th>
        <th style={{ width: 200 }}>{items[index].width}</th>
        <th style={{ width: 200 }}>{items[index].weight}</th>
      </tr>
    );
  }

  return (
    <FixedSizeList
      height={300}
      itemCount={items.length}
      itemSize={30}
      width={1650}
      innerElementType={Table}
    >
      {Row}
    </FixedSizeList>
  );
}
