//
//  ViewController.mm
//

#import <executorch/extension/module/module.h>

#import "ViewController.h"

using namespace ::torch::executor;

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Label für Ergebnis vom Modell definieren...
    UILabel *label = [[UILabel alloc] initWithFrame:self.view.bounds];
    label.textAlignment = NSTextAlignmentCenter;
    // ...und als Subview der App hinzufügen
    [self.view addSubview:label];

    // Inferenz asynchron in eigenem Thread ausführen
    dispatch_async(dispatch_get_global_queue(0, 0), ^{
      // Namen der PTE Datei `add.pte´ zusammensetzen...
      NSString *modelPath = [[NSBundle mainBundle] pathForResource:@"add" ofType:@"pte"];
      // ...und Modell aus Datei laden
      Module module(modelPath.UTF8String);
      // Eingabetensor mit Wert 1 definieren...
      float input[] = { 1 };
      int32_t sizes[] = {std::size(input)};
      TensorImpl inputTensor(ScalarType::Float, std::size(sizes), sizes, input);
      // ...Inferenz ausführen (verwendet Eingabetensor 2x)...
      const auto result = module.forward({EValue(Tensor(&inputTensor)), EValue(Tensor(&inputTensor))});
      // ...Ergebnis abholen...
      const auto output = *result->at(0).toTensor().const_data_ptr<float>();
      // ...und in Label speichern
      dispatch_async(dispatch_get_main_queue(), ^{
        label.text = [NSString stringWithFormat:@"%.f", output];
      });
    });

}

@end
