/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.ViewListener;
import com.icesoft.faces.webapp.command.Command;
import com.icesoft.faces.webapp.command.CommandQueue;
import com.icesoft.faces.webapp.command.NOOP;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Response;
import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.standard.NoCacheContentHandler;
import com.icesoft.faces.webapp.http.core.LifecycleExecutor;
import com.icesoft.faces.webapp.http.core.ResourceDispatcher;
import com.icesoft.faces.webapp.http.core.ViewQueue;
import com.icesoft.faces.webapp.http.portlet.PortletExternalContext;
import com.icesoft.faces.webapp.http.servlet.ServletExternalContext;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.util.SeamUtilities;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.faces.lifecycle.Lifecycle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class View
implements CommandQueue {
    private static final Log Log = LogFactory.getLog((Class)View.class);
    private static final NOOP NOOP = new NOOP();
    private static final Runnable DoNothing = new Runnable(){

        public void run() {
        }
    };
    private final Page lifecycleExecutedPage;
    private Page page;
    private final ReentrantLock queueLock;
    private final ReentrantLock lifecycleLock;
    private BridgeExternalContext externalContext;
    private BridgeFacesContext facesContext;
    private PersistentFacesState persistentFacesState;
    private Map bundles;
    private Command currentCommand;
    private final String viewIdentifier;
    private final ArrayList onPutListeners;
    private final ArrayList onTakeListeners;
    private final Collection viewListeners;
    private final String sessionID;
    private final Configuration configuration;
    private final SessionDispatcher.Monitor sessionMonitor;
    private final ResourceDispatcher resourceDispatcher;
    private final Lifecycle lifecycle;
    private Runnable dispose;
    private String lastPath;

    public View(final String viewIdentifier, String sessionID, final ViewQueue allServedViews, Configuration configuration, SessionDispatcher.Monitor sessionMonitor, ResourceDispatcher resourceDispatcher, Lifecycle lifecycle) throws Exception {
        this.page = this.lifecycleExecutedPage = new Page(){
            private final ResponseHandler lifecycleResponseHandler = new NoCacheContentHandler("text/html", "UTF-8"){

                public void respond(Response response) throws Exception {
                    super.respond(response);
                    SeamUtilities.removeSeamDebugPhaseListener(View.this.lifecycle);
                    View.this.switchToNormalMode();
                    LifecycleExecutor.getLifecycleExecutor(View.this.facesContext).apply(View.this.facesContext);
                    View.this.switchToPushMode();
                }
            };

            public void serve(Request request) throws Exception {
                View.this.updateOnPageRequest(request);
                request.respondWith(this.lifecycleResponseHandler);
            }
        };
        this.queueLock = new ReentrantLock();
        this.lifecycleLock = new ReentrantLock();
        this.bundles = Collections.EMPTY_MAP;
        this.currentCommand = NOOP;
        this.onPutListeners = new ArrayList();
        this.onTakeListeners = new ArrayList();
        this.viewListeners = new ArrayList();
        this.sessionID = sessionID;
        this.configuration = configuration;
        this.viewIdentifier = viewIdentifier;
        this.sessionMonitor = sessionMonitor;
        this.resourceDispatcher = resourceDispatcher;
        this.lifecycle = lifecycle;
        this.persistentFacesState = new PersistentFacesState(this.lifecycleLock, this.viewListeners, configuration){

            public BridgeFacesContext getFacesContext() {
                return View.this.facesContext;
            }
        };
        this.onPut(new Runnable(){

            public void run() {
                try {
                    allServedViews.put(viewIdentifier);
                }
                catch (InterruptedException e) {
                    Log.warn((Object)"Failed to queue updated view", (Throwable)e);
                }
            }
        });
        this.dispose = new Runnable(){

            public void run() {
                Log.debug((Object)("Disposing " + this));
                View.this.installThreadLocals();
                View.this.notifyViewDisposal();
                View.this.releaseAll();
                View.this.releaseLifecycleLockUnconditionally();
                View.this.persistentFacesState.dispose();
                View.this.facesContext.dispose();
                View.this.externalContext.dispose();
                allServedViews.remove(viewIdentifier);
                View.this.dispose = DoNothing;
            }
        };
        Log.debug((Object)("Created " + this));
    }

    public void updateOnXMLHttpRequest(Request request) throws Exception {
        this.acquireLifecycleLock();
        request.detectEnvironment(new Request.Environment(){

            public void servlet(Object request, Object response) {
                View.this.externalContext.update((HttpServletRequest)request, (HttpServletResponse)response);
                View.this.externalContext.insertPostbackKey();
            }

            public void portlet(Object request, Object response, Object config) {
            }
        });
        this.makeCurrent();
    }

    public void servePage(Request request) throws Exception {
        this.acquireLifecycleLock();
        this.page.serve(request);
    }

    private void updateOnPageRequest(Request request) throws Exception {
        String path = request.getURI().getPath();
        boolean reloded = path.equals(this.lastPath);
        this.lastPath = path;
        if (reloded && !SeamUtilities.isSeamEnvironment()) {
            request.detectEnvironment(new Request.Environment(){

                public void servlet(Object servletRequest, Object servletResponse) {
                    View.this.externalContext.updateOnPageLoad(servletRequest, servletResponse);
                }

                public void portlet(Object request, Object response, Object config) {
                    View.this.externalContext.updateOnPageLoad(request, response);
                }
            });
            this.facesContext.renderResponse();
        } else {
            if (this.externalContext != null) {
                this.externalContext.dispose();
            }
            request.detectEnvironment(new Request.Environment(){

                public void servlet(Object servletRequest, Object servletResponse) {
                    View.this.externalContext = new ServletExternalContext(View.this.viewIdentifier, servletRequest, servletResponse, View.this, View.this.configuration, View.this.sessionMonitor);
                }

                public void portlet(Object portletRequest, Object portletResponse, Object portletConfig) {
                    View.this.externalContext = new PortletExternalContext(View.this.viewIdentifier, portletRequest, portletResponse, View.this, View.this.configuration, View.this.sessionMonitor, portletConfig);
                }
            });
            if (this.facesContext != null) {
                this.facesContext.dispose();
            }
            this.facesContext = new BridgeFacesContext(this.externalContext, this.viewIdentifier, this.sessionID, this, this.configuration, this.resourceDispatcher);
        }
        this.makeCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Command command) {
        this.queueLock.lock();
        try {
            this.currentCommand = this.currentCommand.coalesceWith(command);
        }
        finally {
            this.queueLock.unlock();
        }
        this.broadcastTo(this.onPutListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command take() {
        Command command = null;
        this.queueLock.lock();
        try {
            command = this.currentCommand;
            this.currentCommand = NOOP;
        }
        finally {
            this.queueLock.unlock();
        }
        this.broadcastTo(this.onTakeListeners);
        return command;
    }

    public void onPut(Runnable listener) {
        this.onPutListeners.add(listener);
    }

    public void onTake(Runnable listener) {
        this.onTakeListeners.add(listener);
    }

    private void broadcastTo(Collection listeners) {
        Iterator i = listeners.iterator();
        while (i.hasNext()) {
            Runnable listener = (Runnable)i.next();
            try {
                listener.run();
            }
            catch (Exception e) {
                Log.error((Object)("Failed to notify listener: " + listener), (Throwable)e);
            }
        }
    }

    public void release() {
        this.releaseAll();
        this.releaseLifecycleLock();
    }

    public BridgeFacesContext getFacesContext() {
        return this.facesContext;
    }

    public PersistentFacesState getPersistentFacesState() {
        return this.persistentFacesState;
    }

    public void dispose() {
        this.dispose.run();
    }

    public void installThreadLocals() {
        this.persistentFacesState.setCurrentInstance();
        this.facesContext.setCurrentInstance();
    }

    private void makeCurrent() {
        this.installThreadLocals();
        this.externalContext.injectBundles(this.bundles);
        this.facesContext.applyBrowserDOMChanges();
    }

    private void releaseAll() {
        this.facesContext.release();
        this.externalContext.release();
        this.persistentFacesState.release();
    }

    private void acquireLifecycleLock() {
        if (!this.lifecycleLock.isHeldByCurrentThread()) {
            this.lifecycleLock.lock();
        }
    }

    private void releaseLifecycleLock() {
        this.lifecycleLock.lock();
        this.releaseLifecycleLockUnconditionally();
    }

    private void releaseLifecycleLockUnconditionally() {
        while (this.lifecycleLock.getHoldCount() > 0) {
            this.lifecycleLock.unlock();
        }
    }

    private void switchToNormalMode() {
        this.facesContext.switchToNormalMode();
        this.externalContext.switchToNormalMode();
    }

    public String toString() {
        return "View[" + this.sessionID + ":" + this.viewIdentifier + "]";
    }

    void preparePage(final ResponseHandler handler) {
        this.page = new Page(){

            public void serve(Request request) throws Exception {
                request.respondWith(handler);
                View.this.page = View.this.lifecycleExecutedPage;
            }
        };
    }

    private void switchToPushMode() {
        this.bundles = this.externalContext.collectBundles();
        this.facesContext.switchToPushMode();
        this.externalContext.switchToPushMode();
    }

    private void notifyViewDisposal() {
        Iterator i = this.viewListeners.iterator();
        while (i.hasNext()) {
            try {
                ViewListener listener = (ViewListener)i.next();
                listener.viewDisposed();
            }
            catch (Throwable t) {
                Log.warn((Object)"Failed to invoke view listener", t);
            }
        }
    }

    private static interface Page {
        public void serve(Request var1) throws Exception;
    }
}

