/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.DOMUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OutputMessageRenderer
extends DomBasicRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        this.validateParameters(facesContext, uiComponent, null);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
        this.validateParameters(facesContext, uiComponent, null);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        DOMContext domContext;
        boolean escape;
        int numberOfParameters;
        this.validateParameters(facesContext, uiComponent, null);
        boolean spanIsRequired = false;
        String style = (String)uiComponent.getAttributes().get("style");
        String styleClass = (String)uiComponent.getAttributes().get("styleClass");
        if (style != null || styleClass != null || OutputMessageRenderer.idNotNull(uiComponent) || PassThruAttributeRenderer.passThruAttributeExists(uiComponent)) {
            spanIsRequired = true;
        }
        ArrayList<Object> uiParameterChildren = new ArrayList<Object>();
        Iterator allChildren = uiComponent.getChildren().iterator();
        while (allChildren.hasNext()) {
            UIComponent nextChild = (UIComponent)allChildren.next();
            if (!(nextChild instanceof UIParameter)) continue;
            uiParameterChildren.add(((UIParameter)nextChild).getValue());
        }
        String uiComponentValue = null;
        if (uiComponent instanceof ValueHolder) {
            Object uiComponentValueObject = null;
            uiComponentValueObject = ((ValueHolder)uiComponent).getValue();
            if (uiComponentValueObject != null) {
                uiComponentValue = uiComponentValueObject instanceof String ? (String)uiComponentValueObject : uiComponentValueObject.toString();
            }
        }
        if ((numberOfParameters = uiParameterChildren.size()) > 0) {
            Object[] parameters = uiParameterChildren.toArray();
            uiComponentValue = MessageFormat.format(uiComponentValue, parameters);
        }
        if ((escape = DOMUtils.escapeIsRequired(uiComponent)) && uiComponentValue != null) {
            uiComponentValue = DOMUtils.escapeAnsi(uiComponentValue);
        }
        if (!(domContext = DOMContext.attachDOMContext(facesContext, uiComponent)).isInitialized()) {
            Document document = domContext.getDocument();
            Text textNode = document.createTextNode(uiComponentValue);
            if (spanIsRequired) {
                Element rootSpan = domContext.createElement("span");
                domContext.setRootNode(rootSpan);
                if (styleClass != null) {
                    rootSpan.setAttribute("class", styleClass);
                }
                PassThruAttributeRenderer.renderAttributes(facesContext, uiComponent, null);
                rootSpan.appendChild(textNode);
            } else {
                domContext.setRootNode(textNode);
            }
        } else {
            Node rootSpanOrText = domContext.getRootNode();
            if (rootSpanOrText instanceof Text) {
                ((Text)rootSpanOrText).setData(uiComponentValue);
            } else {
                Node textNode = null;
                textNode = rootSpanOrText.getFirstChild();
                if (textNode instanceof Text) {
                    ((Text)textNode).setData(uiComponentValue);
                }
            }
        }
        domContext.stepOver();
    }
}

