/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.servlet.EnvironmentAdaptingException;
import com.icesoft.faces.webapp.http.servlet.GlassFishAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.JettyAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ThreadBlockingAdaptingServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnvironmentAdaptingServlet
implements PseudoServlet {
    private static final Log LOG = LogFactory.getLog((Class)EnvironmentAdaptingServlet.class);
    private static final Object LOCK = new Object();
    private static EnvironmentAdaptingServletFactory factory;
    private static EnvironmentAdaptingServletFactory fallbackFactory;
    private PseudoServlet servlet;
    private PseudoServlet fallbackServlet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentAdaptingServlet(Server server, Configuration configuration, ServletContext servletContext) {
        if (factory == null) {
            Object object = LOCK;
            synchronized (object) {
                if (factory == null) {
                    boolean isGlassFishARPAvailable = this.isGlassFishARPAvailable();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("GlassFish ARP available: " + isGlassFishARPAvailable));
                    }
                    boolean isJettyARPAvailable = this.isJettyARPAvailable();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Jetty ARP available: " + isJettyARPAvailable));
                    }
                    if (isGlassFishARPAvailable && configuration.getAttributeAsBoolean("useARP", isGlassFishARPAvailable)) {
                        LOG.info((Object)"Adapting to GlassFish ARP environment");
                        factory = new GlassFishAdaptingServletFactory();
                        fallbackFactory = new ThreadBlockingAdaptingServletFactory();
                    } else if (isJettyARPAvailable && configuration.getAttributeAsBoolean("useARP", configuration.getAttributeAsBoolean("useJettyContinuations", isJettyARPAvailable))) {
                        LOG.info((Object)"Adapting to Jetty ARP environment");
                        factory = new JettyAdaptingServletFactory();
                        fallbackFactory = new ThreadBlockingAdaptingServletFactory();
                    } else {
                        LOG.info((Object)"Adapting to Thread Blocking environment");
                        factory = new ThreadBlockingAdaptingServletFactory();
                    }
                }
            }
        }
        this.servlet = factory.newServlet(server, servletContext);
        if (fallbackFactory != null) {
            this.fallbackServlet = fallbackFactory.newServlet(server, servletContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.servlet.service(request, response);
        }
        catch (EnvironmentAdaptingException exception) {
            if (fallbackFactory != null) {
                LOG.warn((Object)"Falling back to Thread Blocking environment.");
                Object object = LOCK;
                synchronized (object) {
                    factory = fallbackFactory;
                    fallbackFactory = null;
                }
            }
            if (this.fallbackServlet != null) {
                this.servlet = this.fallbackServlet;
                this.fallbackServlet = null;
                this.servlet.service(request, response);
            }
            throw exception;
        }
    }

    public void shutdown() {
        this.servlet.shutdown();
    }

    private boolean isGlassFishARPAvailable() {
        try {
            this.getClass().getClassLoader().loadClass("com.sun.enterprise.web.connector.grizzly.comet.CometEngine");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private boolean isJettyARPAvailable() {
        try {
            this.getClass().getClassLoader().loadClass("org.mortbay.util.ajax.Continuation");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private static class ThreadBlockingAdaptingServletFactory
    implements EnvironmentAdaptingServletFactory {
        private ThreadBlockingAdaptingServletFactory() {
        }

        public PseudoServlet newServlet(Server server, ServletContext servletContext) {
            return new ThreadBlockingAdaptingServlet(server);
        }
    }

    private static class JettyAdaptingServletFactory
    implements EnvironmentAdaptingServletFactory {
        private JettyAdaptingServletFactory() {
        }

        public PseudoServlet newServlet(Server server, ServletContext servletContext) {
            return new JettyAdaptingServlet(server);
        }
    }

    private static class GlassFishAdaptingServletFactory
    implements EnvironmentAdaptingServletFactory {
        private GlassFishAdaptingServletFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PseudoServlet newServlet(Server server, ServletContext servletContext) {
            try {
                return new GlassFishAdaptingServlet(server, servletContext);
            }
            catch (ServletException exception) {
                LOG.warn((Object)"Failed to adapt to GlassFish ARP environment. Falling back to Thread Blocking environment.", (Throwable)exception);
                Object object = LOCK;
                synchronized (object) {
                    factory = fallbackFactory;
                    fallbackFactory = null;
                }
                return factory.newServlet(server, servletContext);
            }
        }
    }

    private static interface EnvironmentAdaptingServletFactory {
        public PseudoServlet newServlet(Server var1, ServletContext var2);
    }
}

