/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.webapp.http.common.FileLocator;
import com.icesoft.faces.webapp.http.common.MimeTypeMatcher;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.core.DisposeBeans;
import com.icesoft.faces.webapp.http.core.ResourceServer;
import com.icesoft.faces.webapp.http.servlet.BasicAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.DisposeViewsHandler;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.PathDispatcher;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.http.servlet.SessionVerifier;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.jms.JMSAdapter;
import com.icesoft.util.IdGenerator;
import com.icesoft.util.MonitorRunner;
import com.icesoft.util.SeamUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)MainServlet.class);
    private PathDispatcher dispatcher = new PathDispatcher();
    private String contextPath;
    private ServletContext context;
    private MonitorRunner monitorRunner;
    private MessageServiceClient messageServiceClient;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        try {
            final ServletContextConfiguration configuration = new ServletContextConfiguration("com.icesoft.faces", this.context);
            final IdGenerator idGenerator = new IdGenerator(this.context.getResource("/WEB-INF/web.xml").getPath());
            final MimeTypeMatcher mimeTypeMatcher = new MimeTypeMatcher(){

                public String mimeTypeFor(String extension) {
                    return MainServlet.this.context.getMimeType(extension);
                }
            };
            FileLocator localFileLocator = new FileLocator(){

                public File locate(String path) {
                    URI contextURI = URI.create(MainServlet.this.contextPath);
                    URI pathURI = URI.create(path);
                    String result = contextURI.relativize(pathURI).getPath();
                    String fileLocation = MainServlet.this.context.getRealPath(result);
                    return new File(fileLocation);
                }
            };
            this.monitorRunner = new MonitorRunner(configuration.getAttributeAsLong("monitorRunnerInterval", 10000L));
            this.setUpMessageServiceClient();
            RenderManager.setServletConfig(servletConfig);
            BasicAdaptingServlet resourceServer = new BasicAdaptingServlet(new ResourceServer(configuration, mimeTypeMatcher, localFileLocator));
            SessionDispatcher sessionDispatcher = new SessionDispatcher(configuration, this.context){

                protected Server newServer(HttpSession session, SessionDispatcher.Monitor sessionMonitor) {
                    return new MainSessionBoundServlet(session, sessionMonitor, idGenerator, mimeTypeMatcher, MainServlet.this.monitorRunner, configuration, MainServlet.this.messageServiceClient);
                }
            };
            if (SeamUtilities.isSpringEnvironment()) {
                this.dispatcher.dispatchOn("/spring/resources/", resourceServer);
            }
            this.dispatcher.dispatchOn(".*(block\\/)", new SessionVerifier(sessionDispatcher));
            this.dispatcher.dispatchOn(".*(\\.iface$|\\.jsf|\\.faces$|\\.jsp$|\\.jspx$|\\.html$|\\.xhtml$|\\.seam$|uploadHtml$|/spring/)", sessionDispatcher);
            this.dispatcher.dispatchOn(".*", resourceServer);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.contextPath = request.getContextPath();
        try {
            this.dispatcher.service(request, response);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
        this.monitorRunner.stop();
        DisposeBeans.in(this.context);
        this.dispatcher.shutdown();
        this.tearDownMessageServiceClient();
    }

    private boolean isAsyncHttpServiceAvailable() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.icesoft.faces.async.server.AsyncHttpServerAdaptingServlet");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private boolean isJMSAvailable() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("javax.jms.TopicConnectionFactory");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private void setUpMessageServiceClient() {
        if (!this.isAsyncHttpServiceAvailable() || !this.isJMSAvailable()) {
            return;
        }
        try {
            this.messageServiceClient = new MessageServiceClient(new JMSAdapter(this.context), this.context);
            this.messageServiceClient.subscribe("icefacesContextEventTopic", new DisposeViewsHandler().getMessageSelector());
            this.messageServiceClient.start();
        }
        catch (Exception exception) {
            LOG.info((Object)("Did not start Ajax Push JMS services: " + exception));
            this.messageServiceClient = null;
        }
    }

    private void tearDownMessageServiceClient() {
        if (this.messageServiceClient == null) {
            return;
        }
        try {
            this.messageServiceClient.stop();
        }
        catch (MessageServiceException exception) {
            LOG.error((Object)"Failed to close connection due to some internal error!", (Throwable)exception);
        }
    }

    static {
        String headless = "java.awt.headless";
        if (null == System.getProperty("java.awt.headless")) {
            System.setProperty("java.awt.headless", "true");
        }
    }
}

