/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.Request;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.servlet.EnvironmentAdaptingServlet;
import com.icesoft.util.ThreadLocalUtility;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SessionDispatcher
extends EnvironmentAdaptingServlet {
    private static final Log Log = LogFactory.getLog((Class)SessionDispatcher.class);
    private static final Map SessionMonitors = new HashMap();
    private static final CurrentServer CurrentSessionBoundServer = new CurrentServer();
    private final Map sessionBoundServers = new HashMap();
    private ServletContext context;

    public SessionDispatcher(Configuration configuration, ServletContext context) {
        super(new Server(){

            public void service(Request request) throws Exception {
                CurrentSessionBoundServer.lookup().service(request);
            }

            public void shutdown() {
            }
        }, configuration, context);
        this.associateSessionDispatcher(context);
        this.context = context;
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        this.checkSession(session);
        CurrentSessionBoundServer.attach(this.lookupServer(session));
        super.service(request, response);
        CurrentSessionBoundServer.detach();
    }

    public void shutdown() {
        Iterator i = this.sessionBoundServers.values().iterator();
        while (i.hasNext()) {
            Server server = (Server)i.next();
            server.shutdown();
        }
    }

    protected abstract Server newServer(HttpSession var1, Monitor var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSession(HttpSession session) {
        try {
            Monitor monitor;
            String id = session.getId();
            Map map = SessionMonitors;
            synchronized (map) {
                if (!SessionMonitors.containsKey(id)) {
                    monitor = new Monitor(session);
                    SessionMonitors.put(id, monitor);
                } else {
                    monitor = (Monitor)SessionMonitors.get(id);
                }
                monitor.addInSessionContext(this.context);
            }
            map = this.sessionBoundServers;
            synchronized (map) {
                if (!this.sessionBoundServers.containsKey(id)) {
                    this.sessionBoundServers.put(id, this.newServer(session, monitor));
                }
            }
        }
        catch (Exception e) {
            Log.error((Object)e);
        }
    }

    protected Server lookupServer(HttpSession session) {
        return this.lookupServer(session.getId());
    }

    protected Server lookupServer(String sessionId) {
        return (Server)this.sessionBoundServers.get(sessionId);
    }

    private void sessionShutdown(HttpSession session) {
        Server servlet = (Server)this.sessionBoundServers.get(session.getId());
        servlet.shutdown();
    }

    private void sessionDestroy(HttpSession session) {
        this.sessionBoundServers.remove(session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifySessionShutdown(HttpSession session, ServletContext context) {
        Log.debug((Object)("Shutting down session: " + session.getId()));
        String sessionID = session.getId();
        if (!SessionMonitors.containsKey(sessionID)) {
            Log.debug((Object)("Session: " + sessionID + " already shutdown, skipping"));
            return;
        }
        SessionDispatcher sessionDispatcher = SessionDispatcher.lookupSessionDispatcher(context);
        try {
            sessionDispatcher.sessionShutdown(session);
        }
        catch (Exception e) {
            Log.error((Object)e);
        }
        Map map = SessionMonitors;
        synchronized (map) {
            try {
                sessionDispatcher.sessionDestroy(session);
            }
            catch (Exception e) {
                Log.error((Object)e);
            }
            SessionMonitors.remove(sessionID);
        }
    }

    public static Server getSingletonSessionServer(HttpSession session, ServletContext context) {
        return SessionDispatcher.lookupSessionDispatcher(context).lookupServer(session);
    }

    public static Server getSingletonSessionServer(String sessionId, Map applicationMap) {
        return SessionDispatcher.lookupSessionDispatcher(applicationMap).lookupServer(sessionId);
    }

    private void associateSessionDispatcher(ServletContext context) {
        context.setAttribute(SessionDispatcher.class.getName(), (Object)this);
    }

    private static SessionDispatcher lookupSessionDispatcher(ServletContext context) {
        return (SessionDispatcher)context.getAttribute(SessionDispatcher.class.getName());
    }

    private static SessionDispatcher lookupSessionDispatcher(Map applicationMap) {
        return (SessionDispatcher)applicationMap.get(SessionDispatcher.class.getName());
    }

    private static class CurrentServer
    extends ThreadLocal {
        private CurrentServer() {
        }

        public Server lookup() {
            return (Server)this.get();
        }

        public void attach(Server server) {
            this.set(server);
        }

        public void detach() {
            this.set(null);
        }
    }

    public static class Monitor {
        private Set contexts = new HashSet();
        private HttpSession session;
        private long lastAccess;

        private Monitor(HttpSession session) {
            this.session = session;
            this.lastAccess = session.getLastAccessedTime();
        }

        public void touchSession() {
            this.lastAccess = System.currentTimeMillis();
        }

        public Date expiresBy() {
            return new Date(this.lastAccess + (long)(this.session.getMaxInactiveInterval() * 1000));
        }

        public boolean isExpired() {
            long maxInterval;
            long elapsedInterval = System.currentTimeMillis() - this.lastAccess;
            return elapsedInterval + 15000L > (maxInterval = (long)(this.session.getMaxInactiveInterval() * 1000));
        }

        public void shutdown() {
            Iterator i = this.contexts.iterator();
            while (i.hasNext()) {
                ServletContext context = (ServletContext)i.next();
                SessionDispatcher.notifySessionShutdown(this.session, context);
            }
            try {
                this.session.invalidate();
            }
            catch (IllegalStateException e) {
                Log.info((Object)"Session already invalidated.");
            }
        }

        public void shutdownIfExpired() {
            if (this.isExpired()) {
                this.shutdown();
            }
        }

        public void addInSessionContext(ServletContext context) {
            this.contexts.add(context);
        }
    }

    public static class Listener
    implements ServletContextListener,
    HttpSessionListener {
        private boolean run = true;

        public void contextInitialized(ServletContextEvent servletContextEvent) {
            Thread monitor = new Thread("Session Monitor"){

                public void run() {
                    while (Listener.this.run) {
                        try {
                            Iterator iterator = new ArrayList(SessionMonitors.values()).iterator();
                            while (iterator.hasNext()) {
                                Monitor sessionMonitor = (Monitor)iterator.next();
                                sessionMonitor.shutdownIfExpired();
                                ThreadLocalUtility.checkThreadLocals(2);
                            }
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            };
            monitor.setDaemon(true);
            monitor.start();
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
            this.run = false;
        }

        public void sessionCreated(HttpSessionEvent event) {
        }

        public void sessionDestroyed(HttpSessionEvent event) {
            HttpSession session = event.getSession();
            SessionDispatcher.notifySessionShutdown(session, session.getServletContext());
        }
    }
}

