/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.xmlhttp;

import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.ViewListener;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.core.SessionExpiredException;
import com.icesoft.faces.webapp.parser.ImplementationUtil;
import com.icesoft.faces.webapp.xmlhttp.FatalRenderingException;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;
import com.icesoft.faces.webapp.xmlhttp.TransientRenderingException;
import com.icesoft.util.SeamUtilities;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.portlet.PortletSession;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PersistentFacesState
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)PersistentFacesState.class);
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private static final InheritableThreadLocal localInstance = new InheritableThreadLocal();
    private final ClassLoader renderableClassLoader = Thread.currentThread().getContextClassLoader();
    private final Lifecycle lifecycle;
    private final boolean synchronousMode;
    private final Collection viewListeners;
    private final ReentrantLock lifecycleLock;
    private boolean disposed;

    public PersistentFacesState(ReentrantLock lifecycleLock, Collection viewListeners, Configuration configuration) {
        LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        this.lifecycle = factory.getLifecycle("DEFAULT");
        this.lifecycleLock = lifecycleLock;
        this.viewListeners = viewListeners;
        this.synchronousMode = configuration.getAttributeAsBoolean("synchronousUpdate", false);
        this.setCurrentInstance();
    }

    public void dispose() {
        this.disposed = true;
    }

    public void setCurrentInstance() {
        localInstance.set(this);
    }

    public static boolean isThreadLocalNull() {
        return localInstance.get() == null;
    }

    public static PersistentFacesState getInstance() {
        return (PersistentFacesState)localInstance.get();
    }

    public static PersistentFacesState getInstance(Map sessionMap) {
        return PersistentFacesState.getInstance();
    }

    public abstract BridgeFacesContext getFacesContext();

    public boolean isSynchronousMode() {
        return this.synchronousMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() throws RenderingException {
        this.failIfDisposed();
        this.warnIfSynchronous();
        BridgeFacesContext facesContext = this.getFacesContext();
        try {
            this.acquireLifecycleLock();
            this.installThreadLocals();
            facesContext.setFocusId("");
            this.lifecycle.render((FacesContext)facesContext);
        }
        catch (Exception e) {
            this.throwRenderingException(e);
        }
        finally {
            facesContext.release();
            this.releaseAll();
        }
    }

    public void renderLater() {
        this.warnIfSynchronous();
        executorService.execute((Runnable)new RenderRunner());
    }

    public void renderLater(long miliseconds) {
        this.warnIfSynchronous();
        executorService.execute((Runnable)new RenderRunner(miliseconds));
    }

    public void execute() throws RenderingException {
        this.failIfDisposed();
        try {
            this.acquireLifecycleLock();
            this.installThreadLocals();
            BridgeFacesContext facesContext = this.getFacesContext();
            if (ImplementationUtil.isJSF12()) {
                Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
                requestParameterMap.clear();
                if (SeamUtilities.isSeamEnvironment()) {
                    ((BridgeExternalContext)facesContext.getExternalContext()).removeSeamAttributes();
                }
                requestParameterMap.put("javax.faces.ViewState", "ajaxpush");
            } else {
                facesContext.renderResponse();
            }
            this.lifecycle.execute((FacesContext)facesContext);
            if (ImplementationUtil.isJSF12()) {
                facesContext.resetResponseComplete();
            }
        }
        catch (Exception e) {
            this.releaseAll();
            this.throwRenderingException(e);
        }
    }

    public void executeAndRender() throws RenderingException {
        this.acquireLifecycleLock();
        this.execute();
        this.render();
    }

    public void setupAndExecuteAndRender() throws RenderingException {
        this.acquireLifecycleLock();
        this.installContextClassLoader();
        if (SeamUtilities.isSeamEnvironment()) {
            this.testSession();
        }
        this.executeAndRender();
    }

    public void redirectTo(String uri) {
        this.warnIfSynchronous();
        try {
            this.acquireLifecycleLock();
            this.installThreadLocals();
            this.getFacesContext().getExternalContext().redirect(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseAll();
        }
    }

    private void releaseAll() {
        this.release();
        this.releaseLifecycleLock();
    }

    public void navigateTo(String outcome) {
        this.warnIfSynchronous();
        try {
            this.acquireLifecycleLock();
            this.installThreadLocals();
            BridgeFacesContext facesContext = this.getFacesContext();
            facesContext.getApplication().getNavigationHandler().handleNavigation((FacesContext)facesContext, facesContext.getViewRoot().getViewId(), outcome);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.releaseAll();
        }
    }

    public void release() {
        localInstance.set(null);
    }

    public void installContextClassLoader() {
        try {
            Thread.currentThread().setContextClassLoader(this.renderableClassLoader);
        }
        catch (SecurityException se) {
            log.debug((Object)"setting context class loader is not permitted", (Throwable)se);
        }
    }

    public void addViewListener(ViewListener listener) {
        if (!this.viewListeners.contains(listener)) {
            this.viewListeners.add(listener);
        }
    }

    private void acquireLifecycleLock() {
        if (!this.lifecycleLock.isHeldByCurrentThread()) {
            this.lifecycleLock.lock();
        }
    }

    private void releaseLifecycleLock() {
        this.lifecycleLock.lock();
        while (this.lifecycleLock.getHoldCount() > 0) {
            this.lifecycleLock.unlock();
        }
    }

    public void acquireUploadLifecycleLock() {
        this.acquireLifecycleLock();
    }

    public void releaseUploadLifecycleLock() {
        this.releaseLifecycleLock();
    }

    public void setAllCurrentInstances() {
        this.installThreadLocals();
    }

    private void warnIfSynchronous() {
        if (this.synchronousMode) {
            log.warn((Object)"Running in 'synchronous mode'. The page updates were queued but not sent.");
        }
    }

    private void installThreadLocals() {
        this.getFacesContext().setCurrentInstance();
        this.setCurrentInstance();
    }

    private void testSession() throws IllegalStateException {
        Object o = this.getFacesContext().getExternalContext().getSession(false);
        if (o != null) {
            if (o instanceof HttpSession) {
                HttpSession session = (HttpSession)o;
                session.getAttributeNames();
            } else if (o instanceof PortletSession) {
                PortletSession ps = (PortletSession)o;
                ps.getAttributeNames();
            }
        }
    }

    private void fatalRenderingException() throws FatalRenderingException {
        String message = "fatal render failure for viewNumber " + this.getFacesContext().getViewNumber();
        log.debug((Object)message);
        throw new FatalRenderingException(message);
    }

    private void fatalRenderingException(Exception e) throws FatalRenderingException {
        String message = "fatal render failure for viewNumber " + this.getFacesContext().getViewNumber();
        log.debug((Object)message, (Throwable)e);
        throw new FatalRenderingException(message, e);
    }

    private void transientRenderingException(Exception e) throws TransientRenderingException {
        String message = "transient render failure for viewNumber " + this.getFacesContext().getViewNumber();
        log.debug((Object)message, (Throwable)e);
        throw new TransientRenderingException(message, e);
    }

    private void throwRenderingException(Exception e) throws FatalRenderingException, TransientRenderingException {
        Throwable throwable = e;
        while (throwable != null) {
            if (throwable instanceof IllegalStateException || throwable instanceof SessionExpiredException) {
                this.fatalRenderingException(e);
                continue;
            }
            throwable = throwable.getCause();
        }
        this.transientRenderingException(e);
    }

    private void failIfDisposed() throws FatalRenderingException {
        if (this.disposed) {
            this.releaseAll();
            this.fatalRenderingException();
        }
    }

    private class RenderRunner
    implements Runnable {
        private final long delay;

        public RenderRunner() {
            this.delay = 0L;
        }

        public RenderRunner(long miliseconds) {
            this.delay = miliseconds;
        }

        public void run() {
            try {
                Thread.sleep(this.delay);
                PersistentFacesState.this.setupAndExecuteAndRender();
            }
            catch (RenderingException e) {
                log.debug((Object)"renderLater failed ", (Throwable)e);
            }
            catch (InterruptedException e) {
            }
            catch (IllegalStateException e) {
                log.debug((Object)"renderLater failed ", (Throwable)e);
            }
        }
    }
}

