/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.commandsortheader;

import com.icesoft.faces.component.ext.HtmlCommandLink;
import com.icesoft.faces.component.ext.HtmlDataTable;
import com.icesoft.faces.component.ext.taglib.Util;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;

public class CommandSortHeader
extends HtmlCommandLink {
    private String styleClass;
    public static final String COMPONENT_TYPE = "com.icesoft.faces.SortHeader";
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String DEFAULT_RENDERER_TYPE = "com.icesoft.faces.SortHeader";
    private String _columnName = null;
    private Boolean _arrow = null;

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        HtmlDataTable dataTable;
        super.broadcast(event);
        if (event instanceof ActionEvent && (dataTable = this.findParentDataTable()) != null) {
            String colName = this.getColumnName();
            String currentSortColumn = dataTable.getSortColumn();
            boolean currentAscending = dataTable.isSortAscending();
            if (colName.equals(currentSortColumn)) {
                dataTable.setSortColumn(this.getColumnName());
                dataTable.setSortAscending(!currentAscending);
            } else {
                dataTable.setSortColumn(this.getColumnName());
                dataTable.setSortAscending(true);
            }
        }
    }

    public HtmlDataTable findParentDataTable() {
        for (UIComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof HtmlDataTable)) continue;
            return (HtmlDataTable)parent;
        }
        return null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._columnName, this._arrow};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._columnName = (String)values[1];
        this._arrow = (Boolean)values[2];
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceCmdSrtHdr", "styleClass", this.isDisabled());
    }

    public CommandSortHeader() {
        this.setRendererType("com.icesoft.faces.SortHeader");
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void setColumnName(String columnName) {
        this._columnName = columnName;
    }

    public String getColumnName() {
        if (this._columnName != null) {
            return this._columnName;
        }
        ValueBinding vb = this.getValueBinding("columnName");
        return vb != null ? vb.getValue(this.getFacesContext()).toString() : null;
    }

    public void setArrow(boolean arrow) {
        this._arrow = arrow;
    }

    public boolean isArrow() {
        if (this._arrow != null) {
            return this._arrow;
        }
        ValueBinding vb = this.getValueBinding("arrow");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }
}

