/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.inputfile;

import com.icesoft.faces.component.FileUploadComponent;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.inputfile.FileInfo;
import com.icesoft.faces.component.inputfile.InputFileProgressEvent;
import com.icesoft.faces.component.style.OutputStyle;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.utils.MessageUtils;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.util.SeamUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.servlet.ServletContext;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.util.Streams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InputFile
extends UICommand
implements Serializable,
FileUploadComponent {
    private static final Log log = LogFactory.getLog((Class)InputFile.class);
    public static final int DEFAULT = 0;
    public static final int UPLOADING = 1;
    public static final int SAVED = 2;
    public static final int INVALID = 3;
    public static final int SIZE_LIMIT_EXCEEDED = 4;
    public static final int UNKNOWN_SIZE = 5;
    public static final int INVALID_NAME_PATTERN = 6;
    public static final String INVALID_FILE_MESSAGE_ID = "com.icesoft.faces.component.inputfile.INVALID_FILE";
    public static final String INVALID_NAME_PATTERN_MESSAGE_ID = "com.icesoft.faces.component.inputfile.INVALID_NAME_PATTERN";
    public static final String SIZE_LIMIT_EXCEEDED_MESSAGE_ID = "com.icesoft.faces.component.inputfile.SIZE_LIMIT_EXCEEDED";
    public static final String UNKNOWN_SIZE_MESSAGE_ID = "com.icesoft.faces.component.inputfile.UNKNOWN_SIZE";
    public static final String FILE_UPLOAD_PREFIX = "fileUpload";
    public static final String SUBMIT_NONE = "none";
    public static final String SUBMIT_PRE_UPLOAD = "preUpload";
    public static final String SUBMIT_POST_UPLOAD = "postUpload";
    public static final String SUBMIT_PRE_POST_UPLOAD = "preAndPostUpload";
    private Boolean disabled;
    private String style;
    private String styleClass;
    private String label;
    private String enabledOnUserRole;
    private String renderedOnUserRole;
    private String title;
    private int height = 30;
    private int width = 500;
    private int inputTextSize = 35;
    private String inputTextClass;
    private String fileNamePattern;
    private boolean uniqueFolder = true;
    private boolean uniqueFolderSet = false;
    private String uploadDirectory;
    private Boolean uploadDirectoryAbsolute;
    private Throwable uploadException;
    private int status = 0;
    private FileInfo fileInfo = new FileInfo();
    private int progress = 0;
    private File file;
    private long sizeMax;
    private MethodBinding progressListener;
    private Boolean progressRender;
    private String submitOnUpload;
    private String size = null;
    private String buttonClass = null;
    private String onfocus;
    private String onchange;
    private String accept;
    private String accesskey;
    private String onblur;
    private String tabindex;

    public String getComponentType() {
        return "com.icesoft.faces.File";
    }

    public String getRendererType() {
        return "com.icesoft.faces.Upload";
    }

    public String getFamily() {
        return "com.icesoft.faces.File";
    }

    public void upload(FileItemStream stream, String uploadDirectory, boolean uploadDirectoryAbsolute, long maxSize, ServletContext servletContext, String sessionId, PersistentFacesState state) throws IOException {
        Boolean folderAbs;
        this.reset();
        this.uploadException = null;
        this.status = 1;
        this.sizeMax = maxSize;
        FacesContext context = FacesContext.getCurrentInstance();
        String folder = this.getUploadDirectory();
        if (folder == null) {
            folder = uploadDirectory;
        }
        if ((folderAbs = this.getUploadDirectoryAbsolute()) == null) {
            Boolean bl = folderAbs = uploadDirectoryAbsolute ? Boolean.TRUE : Boolean.FALSE;
        }
        if (!folderAbs.booleanValue()) {
            folder = servletContext.getRealPath(folder);
        }
        if (this.isUniqueFolder()) {
            String FILE_SEPARATOR = System.getProperty("file.separator");
            folder = folder + FILE_SEPARATOR + sessionId;
        }
        String namePattern = this.getFileNamePattern().trim();
        String fileName = stream.getName();
        if (File.separatorChar == '/' && fileName.matches("^[a-zA-Z]:\\\\.*?|^\\\\\\\\.*?")) {
            fileName = fileName.substring(fileName.lastIndexOf("\\") + 1);
        }
        try {
            if (fileName == null || fileName.length() <= 0) {
                throw new FileUploadBase.FileUploadIOException((FileUploadException)new FileUploadBase.InvalidContentTypeException());
            }
            File tempFileName = new File(fileName);
            fileName = tempFileName.getName();
            this.fileInfo.setFileName(fileName);
            this.fileInfo.setContentType(stream.getContentType());
            if (fileName != null && fileName.trim().matches(namePattern)) {
                File folderFile = new File(folder);
                if (!folderFile.exists()) {
                    folderFile.mkdirs();
                }
                this.file = new File(folder, fileName);
                FileOutputStream output = new FileOutputStream(this.file);
                Streams.copy((InputStream)stream.openStream(), (OutputStream)output, (boolean)true);
                long fileLength = this.file.length();
                if (fileLength == 0L) {
                    this.setProgressSafely(state, 0);
                    this.file.delete();
                    throw new FileUploadBase.FileUploadIOException((FileUploadException)new FileUploadBase.InvalidContentTypeException());
                }
                this.status = 2;
                this.fileInfo.setPhysicalPath(this.file.getAbsolutePath());
                this.fileInfo.setSize(fileLength);
                this.notifyDoneSafely(state, true);
            } else {
                this.fileInfo.reset();
                this.file = null;
                this.status = 6;
                context.addMessage(this.getClientId(context), MessageUtils.getMessage(context, INVALID_NAME_PATTERN_MESSAGE_ID, new Object[]{fileName, namePattern}));
                this.notifyDoneSafely(state, false);
            }
        }
        catch (FileUploadBase.FileUploadIOException uploadException) {
            this.uploadException = uploadException.getCause();
            try {
                throw this.uploadException;
            }
            catch (FileUploadBase.FileSizeLimitExceededException e) {
                this.status = 4;
            }
            catch (FileUploadBase.UnknownSizeException e) {
                this.status = 5;
            }
            catch (FileUploadBase.InvalidContentTypeException e) {
                this.status = 3;
            }
            catch (Throwable t) {
                this.status = 3;
            }
            this.fileInfo.setException((Exception)((Object)uploadException));
            if (this.file != null) {
                this.file.delete();
            }
            this.notifyDoneSafely(state, false);
            throw uploadException;
        }
        catch (IOException e) {
            this.uploadException = e;
            this.status = 3;
            this.fileInfo.setException(e);
            if (this.file != null) {
                this.file.delete();
            }
            this.notifyDoneSafely(state, false);
            throw e;
        }
        this.renderIfAppropriate(state, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDoneSafely(PersistentFacesState state, boolean updateFile) {
        state.acquireUploadLifecycleLock();
        try {
            state.setAllCurrentInstances();
            if (updateFile) {
                this.updateFileValueBinding();
            }
            this.notifyDone();
        }
        finally {
            state.releaseUploadLifecycleLock();
        }
    }

    protected void notifyDone() {
        ActionEvent event = new ActionEvent((UIComponent)this);
        MethodBinding actionListener = this.getActionListener();
        if (actionListener != null) {
            actionListener.invoke(FacesContext.getCurrentInstance(), new Object[]{event});
        }
        ActionListener[] actionListeners = this.getActionListeners();
        for (int i = 0; i < actionListeners.length; ++i) {
            actionListeners[i].processAction(event);
        }
        MethodBinding action = this.getAction();
        if (action != null) {
            action.invoke(FacesContext.getCurrentInstance(), null);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof InputFileProgressEvent) {
            if (this.fileInfo.isPreUpload()) {
                this.reset();
                this.fileInfo.setPreUpload(true);
            }
            if (this.progressListener != null) {
                this.progressListener.invoke(FacesContext.getCurrentInstance(), new Object[]{event});
            }
            this.setPreUpload(false);
            this.setPostUpload(false);
        }
    }

    public void renderIFrame(Writer writer, BridgeFacesContext context) throws IOException {
        String title;
        writer.write("<html style=\"overflow:hidden;\">");
        ArrayList outputStyleComponents = InputFile.findOutputStyleComponents((UIComponent)context.getViewRoot());
        if (outputStyleComponents != null) {
            writer.write("<head>");
            for (int i = 0; i < outputStyleComponents.size(); ++i) {
                OutputStyle outputStyle = (OutputStyle)((Object)outputStyleComponents.get(i));
                String href = outputStyle.getHref();
                if (href == null || href.length() <= 0) continue;
                href = CoreUtils.resolveResourceURL((FacesContext)context, (String)href);
                writer.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + href + "\">");
            }
            writer.write("</head>");
        }
        String srv = this.getUploadServletPath(context);
        writer.write("<body style=\"background-color:transparent; overflow:hidden\"><form method=\"post\" action=\"" + srv + "\" enctype=\"multipart/form-data\" id=\"fileUploadForm\">");
        writer.write("<input type=\"hidden\" name=\"ice.component\" value=\"");
        writer.write(this.getClientId((FacesContext)context));
        writer.write("\"/>");
        writer.write("<input type=\"hidden\" name=\"ice.view\"");
        writer.write(" value=\"" + context.getViewNumber() + "\"/>");
        writer.write("<input type=\"file\" name=\"upload\"");
        writer.write(" size=\"" + this.getInputTextSize() + "\"");
        String inputTextClass = this.getInputTextClass();
        if (inputTextClass != null) {
            writer.write(" class=\"" + inputTextClass + "\"");
        }
        if ((title = this.getTitle()) != null) {
            writer.write(" title=\"" + title + "\"");
        }
        writer.write("/>");
        writer.write("<input type=\"submit\" value=\"" + this.getLabel() + "\"");
        String buttonClass = this.getButtonClass();
        if (buttonClass != null) {
            writer.write(" class=\"" + buttonClass + "\"");
        }
        if (this.isDisabled()) {
            writer.write(" disabled=\"disabled\"");
        }
        writer.write("/>");
        writer.write("</form>");
        writer.write("</body></html>");
    }

    private String getUploadServletPath(BridgeFacesContext context) {
        ExternalContext externalContext;
        String requestContextPath = null;
        if (context != null && (externalContext = context.getExternalContext()) != null) {
            requestContextPath = externalContext.getRequestContextPath();
        }
        if (requestContextPath == null || requestContextPath.length() == 0) {
            return "./uploadHtml";
        }
        return requestContextPath + "/uploadHtml";
    }

    public Throwable getUploadException() {
        return this.uploadException;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setUniqueFolder(boolean uniqueFolder) {
        if (uniqueFolder != this.uniqueFolder) {
            this.uniqueFolder = uniqueFolder;
        }
        this.uniqueFolderSet = true;
    }

    public boolean isUniqueFolder() {
        if (this.uniqueFolderSet) {
            return this.uniqueFolder;
        }
        ValueBinding vb = this.getValueBinding("uniqueFolder");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(this.getFacesContext()));
        }
        return true;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        ValueBinding vb = this.getValueBinding("label");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "Upload";
    }

    public boolean isDisabled() {
        if (!Util.isEnabledOnUserRole((UIComponent)this)) {
            return true;
        }
        if (this.disabled != null) {
            return this.disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        Boolean boolVal = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return boolVal != null ? boolVal : false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setEnabledOnUserRole(String enabledOnUserRole) {
        this.enabledOnUserRole = enabledOnUserRole;
    }

    public String getEnabledOnUserRole() {
        if (this.enabledOnUserRole != null) {
            return this.enabledOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("enabledOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setUploadDirectory(String uploadDirectory) {
        this.uploadDirectory = uploadDirectory;
    }

    public String getUploadDirectory() {
        if (this.uploadDirectory != null) {
            return this.uploadDirectory;
        }
        ValueBinding vb = this.getValueBinding("uploadDirectory");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setUploadDirectoryAbsolute(Boolean uploadDirectoryAbsolute) {
        this.uploadDirectoryAbsolute = uploadDirectoryAbsolute;
    }

    public Boolean getUploadDirectoryAbsolute() {
        if (this.uploadDirectoryAbsolute != null) {
            return this.uploadDirectoryAbsolute;
        }
        ValueBinding vb = this.getValueBinding("uploadDirectoryAbsolute");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
    }

    public void setProgressRender(Boolean progressRender) {
        this.progressRender = progressRender;
    }

    public Boolean getProgressRender() {
        if (this.progressRender != null) {
            return this.progressRender;
        }
        ValueBinding vb = this.getValueBinding("progressRender");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean renderOnProgress() {
        Boolean progRend = this.getProgressRender();
        return progRend != null ? progRend : false;
    }

    public void setSubmitOnUpload(String submitOnUpload) {
        this.submitOnUpload = submitOnUpload;
    }

    public String getSubmitOnUpload() {
        if (this.submitOnUpload != null) {
            return this.submitOnUpload;
        }
        ValueBinding vb = this.getValueBinding("submitOnUpload");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public String getValidatedSubmitOnUpload() {
        String sol = this.getSubmitOnUpload();
        if (sol == null || sol.length() == 0) {
            sol = SUBMIT_NONE;
        } else if (!(sol.equals(SUBMIT_NONE) || sol.equals(SUBMIT_PRE_UPLOAD) || sol.equals(SUBMIT_POST_UPLOAD) || sol.equals(SUBMIT_PRE_POST_UPLOAD))) {
            throw new FacesException((Throwable)new IllegalArgumentException("Invalid value for ice:inputFile's submitOnUpload property: " + sol));
        }
        return sol;
    }

    public void setRenderedOnUserRole(String renderedOnUserRole) {
        this.renderedOnUserRole = renderedOnUserRole;
    }

    public String getRenderedOnUserRole() {
        if (this.renderedOnUserRole != null) {
            return this.renderedOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("renderedOnUserRole");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public boolean isRendered() {
        if (!Util.isRenderedOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "border-collapse:collapse; border-spacing:0px; padding:0px;";
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceInpFile", "styleClass", this.isDisabled());
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.disabled, this.style, this.styleClass, this.label, this.enabledOnUserRole, this.renderedOnUserRole, this.title, new Integer(this.height), new Integer(this.width), new Integer(this.inputTextSize), this.inputTextClass, this.fileNamePattern, this.uniqueFolder ? Boolean.TRUE : Boolean.FALSE, this.uniqueFolderSet ? Boolean.TRUE : Boolean.FALSE, this.uploadDirectory, this.uploadDirectoryAbsolute, this.uploadException, new Integer(this.status), this.fileInfo, new Integer(this.progress), this.file, new Long(this.sizeMax), InputFile.saveAttachedState((FacesContext)context, (Object)this.progressListener), this.progressRender, this.submitOnUpload};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.disabled = (Boolean)values[1];
        this.style = (String)values[2];
        this.styleClass = (String)values[3];
        this.label = (String)values[4];
        this.enabledOnUserRole = (String)values[5];
        this.renderedOnUserRole = (String)values[6];
        this.title = (String)values[7];
        this.height = (Integer)values[8];
        this.width = (Integer)values[9];
        this.inputTextSize = (Integer)values[10];
        this.inputTextClass = (String)values[11];
        this.fileNamePattern = (String)values[12];
        this.uniqueFolder = (Boolean)values[13];
        this.uniqueFolderSet = (Boolean)values[14];
        this.uploadDirectory = (String)values[15];
        this.uploadDirectoryAbsolute = (Boolean)values[16];
        this.uploadException = (Throwable)values[17];
        this.status = (Integer)values[18];
        this.fileInfo = (FileInfo)values[19];
        this.progress = (Integer)values[20];
        this.file = (File)values[21];
        this.sizeMax = (Long)values[22];
        this.progressListener = (MethodBinding)InputFile.restoreAttachedState((FacesContext)context, (Object)values[23]);
        this.progressRender = (Boolean)values[24];
        this.submitOnUpload = (String)values[25];
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        ValueBinding vb = this.getValueBinding("title");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSize() {
        if (this.size != null) {
            return this.size;
        }
        ValueBinding vb = this.getValueBinding("size");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public int getHeight() {
        ValueBinding vb = this.getValueBinding("height");
        if (vb != null) {
            Integer value = (Integer)vb.getValue(this.getFacesContext());
            if (null == value) {
                return this.height;
            }
            return value;
        }
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        ValueBinding vb = this.getValueBinding("width");
        if (vb != null) {
            Integer value = (Integer)vb.getValue(this.getFacesContext());
            if (null == value) {
                return this.width;
            }
            return value;
        }
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getInputTextSize() {
        ValueBinding vb = this.getValueBinding("inputTextSize");
        if (vb != null) {
            Integer value = (Integer)vb.getValue(this.getFacesContext());
            if (null == value) {
                return this.inputTextSize;
            }
            return value;
        }
        return this.inputTextSize;
    }

    public void setInputTextSize(int inputTextSize) {
        this.inputTextSize = inputTextSize;
    }

    public String getFileNamePattern() {
        if (this.fileNamePattern != null) {
            return this.fileNamePattern;
        }
        ValueBinding vb = this.getValueBinding("fileNamePattern");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : ".+";
    }

    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public void setInputTextClass(String inputTextClass) {
        this.inputTextClass = inputTextClass;
    }

    public String getInputTextClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.inputTextClass, "Txt", "inputTextClass", this.isDisabled());
    }

    public void setButtonClass(String buttonClass) {
        this.buttonClass = buttonClass;
    }

    public String getButtonClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.buttonClass, "Btn", "buttonClass", this.isDisabled());
    }

    boolean isRegister() {
        return false;
    }

    public void setRegister(FacesContext facesContext) {
    }

    public FileInfo getFileInfo() {
        if (this.fileInfo == null) {
            return null;
        }
        return (FileInfo)this.fileInfo.clone();
    }

    void setFileInfo(FileInfo fileInfo) {
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
    }

    protected void updateFileValueBinding() {
        try {
            ValueBinding vb = this.getValueBinding("file");
            if (vb != null) {
                vb.setValue(FacesContext.getCurrentInstance(), (Object)this.getFile());
            }
        }
        catch (Exception e) {
            log.warn((Object)"The InputFile's file attribute has a ValueBinding, whose value could not be set", (Throwable)e);
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getFilename() {
        return this.fileInfo.getFileName();
    }

    public void setFilename(String filename) {
        this.fileInfo.setFileName(filename);
    }

    public long getFilesize() {
        return this.fileInfo.getSize();
    }

    public void setFilesize(long filesize) {
        this.fileInfo.setSize(filesize);
    }

    public long getSizeMax() {
        return this.sizeMax;
    }

    public MethodBinding getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(MethodBinding binding) {
        this.progressListener = binding;
    }

    public int getProgress() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProgressSafely(PersistentFacesState state, int i) {
        state.acquireUploadLifecycleLock();
        try {
            state.setAllCurrentInstances();
            this.setProgress(i);
        }
        finally {
            state.releaseUploadLifecycleLock();
        }
    }

    public void setProgress(int i) {
        this.progress = i;
        this.fileInfo.setPercent(i);
        if (this.getProgressListener() != null) {
            this.getProgressListener().invoke(FacesContext.getCurrentInstance(), new Object[]{new InputFileProgressEvent((UIComponent)this)});
        }
    }

    public void updateProgress(PersistentFacesState state, int i) {
        this.setProgressSafely(state, i);
        this.renderIfAppropriate(state, this.renderOnProgress());
    }

    private void renderIfAppropriate(PersistentFacesState state, boolean appropriate) {
        if (!appropriate) {
            return;
        }
        if (!state.isSynchronousMode()) {
            try {
                if (SeamUtilities.isSeamEnvironment() || SeamUtilities.isSpringEnvironment()) {
                    state.setupAndExecuteAndRender();
                    state.setAllCurrentInstances();
                } else {
                    state.renderLater();
                }
            }
            catch (Exception e) {
                log.warn((Object)"Problem rendering view during file upload", (Throwable)e);
            }
        }
    }

    void setPreUpload(boolean p) {
        this.fileInfo.setPreUpload(p);
    }

    void setPostUpload(boolean p) {
        this.fileInfo.setPostUpload(p);
    }

    public String getCssFile() {
        return null;
    }

    private String getDisabled() {
        return null;
    }

    private String getStyleClassString() {
        return null;
    }

    private String getStyleString() {
        return null;
    }

    private String getStyleInfo() {
        return null;
    }

    private String getInputTextClassString() {
        return null;
    }

    private String getButtonClassString() {
        return null;
    }

    private String getTitleAsString() {
        return null;
    }

    private static ArrayList findOutputStyleComponents(UIComponent parent) {
        ArrayList returnValue = null;
        Iterator children = parent.getChildren().iterator();
        UIComponent childComponent = null;
        while (children.hasNext()) {
            childComponent = (UIComponent)children.next();
            if (childComponent instanceof OutputStyle) {
                if (returnValue == null) {
                    returnValue = new ArrayList();
                }
                returnValue.add(childComponent);
                continue;
            }
            ArrayList outputStyleComponents = InputFile.findOutputStyleComponents(childComponent);
            if (outputStyleComponents == null) continue;
            if (returnValue == null) {
                returnValue = outputStyleComponents;
                continue;
            }
            returnValue.addAll(outputStyleComponents);
        }
        return returnValue;
    }

    public void setOnfocus(String onfocus) {
        this.onfocus = onfocus;
    }

    public String getOnfocus() {
        if (this.onfocus != null) {
            return this.onfocus;
        }
        ValueBinding vb = this.getValueBinding("onfocus");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getOnchange() {
        if (this.onchange != null) {
            return this.onchange;
        }
        ValueBinding vb = this.getValueBinding("onchange");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public String getAccept() {
        if (this.accept != null) {
            return this.accept;
        }
        ValueBinding vb = this.getValueBinding("accept");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public String getAccesskey() {
        if (this.accesskey != null) {
            return this.accesskey;
        }
        ValueBinding vb = this.getValueBinding("accesskey");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setOnblur(String onblur) {
        this.onblur = onblur;
    }

    public String getOnblur() {
        if (this.onblur != null) {
            return this.onblur;
        }
        ValueBinding vb = this.getValueBinding("onblur");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }

    public String getTabindex() {
        if (this.tabindex != null) {
            return this.tabindex;
        }
        ValueBinding vb = this.getValueBinding("tabindex");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void reset() {
        String clientId;
        Iterator msgs;
        this.uploadException = null;
        this.status = 0;
        this.fileInfo = new FileInfo();
        this.progress = 0;
        this.file = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (msgs = facesContext.getMessages(clientId = this.getClientId(facesContext))) != null) {
            while (msgs.hasNext()) {
                FacesMessage msg = (FacesMessage)msgs.next();
                msgs.remove();
            }
        }
    }
}

