/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.MultipartStream;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.servlet.ServletRequestContext;

public class StreamingTest
extends TestCase {
    public void testFileUpload() throws IOException, FileUploadException {
        byte[] request = this.newRequest();
        List fileItems = this.parseUpload(request);
        Iterator fileIter = fileItems.iterator();
        int add = 16;
        int num = 0;
        int i = 0;
        while (i < 16384) {
            if (++add == 32) {
                add = 16;
            }
            FileItem item = (FileItem)fileIter.next();
            Assert.assertEquals((String)("field" + num++), (String)item.getFieldName());
            byte[] bytes = item.get();
            Assert.assertEquals((int)i, (int)bytes.length);
            int j = 0;
            while (j < i) {
                Assert.assertEquals((byte)((byte)j), (byte)bytes[j]);
                ++j;
            }
            i += add;
        }
        Assert.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    public void testFileUploadException() throws IOException, FileUploadException {
        byte[] request = this.newRequest();
        byte[] invalidRequest = new byte[request.length - 11];
        System.arraycopy(request, 0, invalidRequest, 0, request.length - 11);
        try {
            this.parseUpload(invalidRequest);
            Assert.fail((String)"Expected EndOfStreamException");
        }
        catch (FileUploadBase.IOFileUploadException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof MultipartStream.MalformedStreamException));
        }
    }

    public void testIOException() throws IOException {
        byte[] request = this.newRequest();
        FilterInputStream stream = new FilterInputStream(new ByteArrayInputStream(request)){
            private int num;

            public int read() throws IOException {
                if (++this.num > 123) {
                    throw new IOException("123");
                }
                return super.read();
            }

            public int read(byte[] pB, int pOff, int pLen) throws IOException {
                int i = 0;
                while (i < pLen) {
                    int res = this.read();
                    if (res == -1) {
                        return i == 0 ? -1 : i;
                    }
                    pB[pOff + i] = (byte)res;
                    ++i;
                }
                return pLen;
            }
        };
        try {
            this.parseUpload(stream, request.length);
            Assert.fail((String)"Expected IOException");
        }
        catch (FileUploadException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
            Assert.assertEquals((String)"123", (String)e.getCause().getMessage());
        }
    }

    public void testFILEUPLOAD135() throws IOException, FileUploadException {
        byte[] request = this.newShortRequest();
        final ByteArrayInputStream bais = new ByteArrayInputStream(request);
        List fileItems = this.parseUpload(new InputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public int read(byte[] b, int off, int len) throws IOException {
                return bais.read(b, off, Math.min(len, 3));
            }
        }, request.length);
        Iterator fileIter = fileItems.iterator();
        Assert.assertTrue((boolean)fileIter.hasNext());
        FileItem item = (FileItem)fileIter.next();
        Assert.assertEquals((String)"field", (String)item.getFieldName());
        byte[] bytes = item.get();
        Assert.assertEquals((int)3, (int)bytes.length);
        Assert.assertEquals((byte)49, (byte)bytes[0]);
        Assert.assertEquals((byte)50, (byte)bytes[1]);
        Assert.assertEquals((byte)51, (byte)bytes[2]);
        Assert.assertTrue((!fileIter.hasNext() ? 1 : 0) != 0);
    }

    private List parseUpload(byte[] bytes) throws FileUploadException {
        return this.parseUpload(new ByteArrayInputStream(bytes), bytes.length);
    }

    private List parseUpload(InputStream pStream, int pLength) throws FileUploadException {
        String contentType = "multipart/form-data; boundary=---1234";
        ServletFileUpload upload = new ServletFileUpload();
        ((FileUploadBase)upload).setFileItemFactory(new DiskFileItemFactory());
        MockHttpServletRequest request = new MockHttpServletRequest(pStream, pLength, contentType);
        List fileItems = upload.parseRequest(new ServletRequestContext(request));
        return fileItems;
    }

    private String getHeader(String pField) {
        return "-----1234\r\nContent-Disposition: form-data; name=\"" + pField + "\"\r\n" + "\r\n";
    }

    private String getFooter() {
        return "-----1234--\r\n";
    }

    private byte[] newShortRequest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "US-ASCII");
        osw.write(this.getHeader("field"));
        osw.write("123");
        osw.write("\r\n");
        osw.write(this.getFooter());
        osw.close();
        return baos.toByteArray();
    }

    private byte[] newRequest() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "US-ASCII");
        int add = 16;
        int num = 0;
        int i = 0;
        while (i < 16384) {
            if (++add == 32) {
                add = 16;
            }
            osw.write(this.getHeader("field" + num++));
            osw.flush();
            int j = 0;
            while (j < i) {
                baos.write((byte)j);
                ++j;
            }
            osw.write("\r\n");
            i += add;
        }
        osw.write(this.getFooter());
        osw.close();
        return baos.toByteArray();
    }
}

