/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent.locks;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Lock;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

class CondVar
implements Condition,
Serializable {
    protected final ExclusiveLock lock;

    CondVar(ExclusiveLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly() {
        boolean wasInterrupted = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                while (true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        wasInterrupted = true;
                        continue;
                    }
                    break;
                }
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.lock.lock();
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            throw throwable;
        }
        this.lock.lock();
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        finally {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    if (nanos > 0L) {
                        long start = Utils.nanoTime();
                        TimeUnit.NANOSECONDS.timedWait(this, nanos);
                        success = Utils.nanoTime() - start < nanos;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        finally {
            this.lock.lock();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (deadline == null) {
            throw new NullPointerException();
        }
        long abstime = deadline.getTime();
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean success = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.lock.unlock();
                try {
                    long start = System.currentTimeMillis();
                    long msecs = abstime - start;
                    if (msecs > 0L) {
                        this.wait(msecs);
                        success = System.currentTimeMillis() - start < msecs;
                    }
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
        }
        finally {
            this.lock.lock();
        }
        return success;
    }

    public synchronized void signal() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notify();
    }

    public synchronized void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        this.notifyAll();
    }

    protected ExclusiveLock getLock() {
        return this.lock;
    }

    protected boolean hasWaiters() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected int getWaitQueueLength() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    protected Collection getWaitingThreads() {
        throw new UnsupportedOperationException("Use FAIR version");
    }

    static interface ExclusiveLock
    extends Lock {
        public boolean isHeldByCurrentThread();
    }
}

