/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.web.ui.appbase;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public abstract class FacesBean {
    private static final String DATA_KEY = "com.sun.rave.web.ui.appbase.DATA";

    protected Application getApplication() {
        return FacesContext.getCurrentInstance().getApplication();
    }

    protected Map getApplicationMap() {
        return this.getExternalContext().getApplicationMap();
    }

    protected List getCachedExceptions() {
        return (List)this.getFacesContext().getExternalContext().getRequestMap().get("com.sun.rave.web.ui.appbase.CACHED_EXCEPTIONS");
    }

    protected FacesContext getContext() {
        return this.getFacesContext();
    }

    protected ExternalContext getExternalContext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }

    protected FacesContext getFacesContext() {
        return FacesContext.getCurrentInstance();
    }

    protected Lifecycle getLifecycle() {
        String lifecycleId = this.getExternalContext().getInitParameter("javax.faces.LIFECYCLE_ID");
        if (lifecycleId == null || lifecycleId.length() == 0) {
            lifecycleId = "DEFAULT";
        }
        LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
        return lifecycleFactory.getLifecycle(lifecycleId);
    }

    protected Map getRequestMap() {
        return this.getExternalContext().getRequestMap();
    }

    protected Map getSessionMap() {
        return this.getExternalContext().getSessionMap();
    }

    protected Object getBean(String name) {
        return this.getApplication().getVariableResolver().resolveVariable(this.getFacesContext(), name);
    }

    protected void setBean(String name, Object value) {
        this.setValue("#{" + name + "}", value);
    }

    public Object retrieveData(String key) {
        FacesContext context = this.getFacesContext();
        if (context == null) {
            return null;
        }
        UIViewRoot view = context.getViewRoot();
        if (view == null) {
            return null;
        }
        Map map = (Map)view.getAttributes().get(DATA_KEY);
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public void saveData(String key, Object data) {
        HashMap<String, Object> map = (HashMap<String, Object>)this.getFacesContext().getViewRoot().getAttributes().get(DATA_KEY);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.getFacesContext().getViewRoot().getAttributes().put(DATA_KEY, map);
        }
        map.put(key, data);
    }

    protected Object getValue(String expr) {
        ValueBinding vb = this.getApplication().createValueBinding(expr);
        return vb.getValue(this.getFacesContext());
    }

    protected void setValue(String expr, Object value) {
        ValueBinding vb = this.getApplication().createValueBinding(expr);
        vb.setValue(this.getFacesContext(), value);
    }

    protected void erase() {
        this.erase((UIComponent)this.getFacesContext().getViewRoot());
    }

    private void erase(UIComponent component) {
        if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).setSubmittedValue(null);
        }
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            this.erase((UIComponent)kids.next());
        }
    }

    protected void log(String message) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            this.getExternalContext().log(message);
        }
    }

    protected void log(String message, Throwable throwable) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            this.getExternalContext().log(message, throwable);
        } else {
            throwable.printStackTrace(System.out);
        }
    }

    protected void info(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null));
    }

    protected void info(UIComponent component, String summary) {
        this.getFacesContext().addMessage(component.getClientId(this.getFacesContext()), new FacesMessage(FacesMessage.SEVERITY_INFO, summary, null));
    }

    protected void warn(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_WARN, summary, null));
    }

    protected void warn(UIComponent component, String summary) {
        this.getFacesContext().addMessage(component.getClientId(this.getFacesContext()), new FacesMessage(FacesMessage.SEVERITY_WARN, summary, null));
    }

    protected void error(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, null));
    }

    protected void error(UIComponent component, String summary) {
        this.getFacesContext().addMessage(component.getClientId(this.getFacesContext()), new FacesMessage(FacesMessage.SEVERITY_ERROR, summary, null));
    }

    protected void fatal(String summary) {
        this.getFacesContext().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_FATAL, summary, null));
    }

    protected void fatal(UIComponent component, String summary) {
        this.getFacesContext().addMessage(component.getClientId(this.getFacesContext()), new FacesMessage(FacesMessage.SEVERITY_FATAL, summary, null));
    }
}

