/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rave.faces.lifecycle;

import com.sun.rave.faces.lifecycle.LifeCycleEvent;
import com.sun.rave.faces.lifecycle.LifeCycleListener;
import java.beans.Beans;
import java.util.Hashtable;
import java.util.Iterator;
import javax.faces.FactoryFinder;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.LifecycleFactory;

public class CreatorLifeCycle {
    private Hashtable listeners;

    public CreatorLifeCycle() {
        if (!Beans.isDesignTime()) {
            this.listeners = new Hashtable();
            LifecycleFactory lifecycleFactory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = FacesContext.getCurrentInstance().getExternalContext().getInitParameter("javax.faces.lifecycle.LIFECYCLE_ID");
            if (lifecycleId == null) {
                lifecycleId = "DEFAULT";
            }
            lifecycleFactory.getLifecycle(lifecycleId).addPhaseListener(new PhaseListener(){

                public void afterPhase(PhaseEvent event) {
                    Iterator i = CreatorLifeCycle.this.listeners.keySet().iterator();
                    while (i.hasNext()) {
                        LifeCycleListener listener = (LifeCycleListener)i.next();
                        UIViewRoot viewRoot = (UIViewRoot)CreatorLifeCycle.this.listeners.get(listener);
                        if (viewRoot != FacesContext.getCurrentInstance().getViewRoot()) continue;
                        LifeCycleEvent lifeCycleEvent = new LifeCycleEvent(event.getFacesContext(), event.getPhaseId());
                        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
                            listener.postRestoreView(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
                            listener.postApplyRequestValues(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() == PhaseId.PROCESS_VALIDATIONS) {
                            listener.postProcessValidations(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() == PhaseId.UPDATE_MODEL_VALUES) {
                            listener.postUpdateModelValues(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
                            listener.postInvokeApplication(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() != PhaseId.RENDER_RESPONSE) continue;
                        listener.postRenderResponse(lifeCycleEvent);
                    }
                }

                public void beforePhase(PhaseEvent event) {
                    Iterator i = CreatorLifeCycle.this.listeners.keySet().iterator();
                    while (i.hasNext()) {
                        LifeCycleListener listener = (LifeCycleListener)i.next();
                        UIViewRoot viewRoot = (UIViewRoot)CreatorLifeCycle.this.listeners.get(listener);
                        if (viewRoot != FacesContext.getCurrentInstance().getViewRoot()) continue;
                        LifeCycleEvent lifeCycleEvent = new LifeCycleEvent(event.getFacesContext(), event.getPhaseId());
                        if (event.getPhaseId() == PhaseId.RESTORE_VIEW) {
                            listener.preRestoreView(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() == PhaseId.APPLY_REQUEST_VALUES) {
                            listener.preApplyRequestValues(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() == PhaseId.PROCESS_VALIDATIONS) {
                            listener.preProcessValidations(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() == PhaseId.UPDATE_MODEL_VALUES) {
                            listener.preUpdateModelValues(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() == PhaseId.INVOKE_APPLICATION) {
                            listener.preInvokeApplication(lifeCycleEvent);
                            continue;
                        }
                        if (event.getPhaseId() != PhaseId.RENDER_RESPONSE) continue;
                        listener.preRenderResponse(lifeCycleEvent);
                    }
                }

                public PhaseId getPhaseId() {
                    return PhaseId.ANY_PHASE;
                }
            });
        }
    }

    public void addLifeCycleListener(LifeCycleListener listener) {
        if (!Beans.isDesignTime()) {
            this.listeners.put(listener, FacesContext.getCurrentInstance().getViewRoot());
        }
    }

    public void removeLifeCycleListener(LifeCycleListener listener) {
        if (!Beans.isDesignTime()) {
            this.listeners.remove(listener);
        }
    }
}

