/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.AsyncRenderer;
import com.icesoft.faces.async.render.BroadcastHub;
import com.icesoft.faces.async.render.ContextDestroyedListener;
import com.icesoft.faces.async.render.DelayRenderer;
import com.icesoft.faces.async.render.Disposable;
import com.icesoft.faces.async.render.IntervalRenderer;
import com.icesoft.faces.async.render.OnDemandRenderer;
import com.icesoft.faces.async.render.RenderHub;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenderManager
implements Disposable {
    static final int MIN = 1;
    public static final int ON_DEMAND = 2;
    public static final int INTERVAL = 3;
    public static final int DELAY = 4;
    static final int MAX = 4;
    private static RenderManager internalRenderManager;
    static /* synthetic */ Class class$com$icesoft$faces$async$render$RenderManager$InternalRenderManager;

    public void dispose() {
    }

    public DelayRenderer getDelayRenderer(String rendererName) {
        return internalRenderManager != null ? internalRenderManager.getDelayRenderer(rendererName) : null;
    }

    public static RenderManager getInstance() {
        return internalRenderManager;
    }

    public IntervalRenderer getIntervalRenderer(String rendererName) {
        return internalRenderManager != null ? internalRenderManager.getIntervalRenderer(rendererName) : null;
    }

    public OnDemandRenderer getOnDemandRenderer(String rendererName) {
        return internalRenderManager != null ? internalRenderManager.getOnDemandRenderer(rendererName) : null;
    }

    public AsyncRenderer getRenderer(String rendererName) {
        return internalRenderManager != null ? internalRenderManager.getRenderer(rendererName) : null;
    }

    public boolean isBroadcasted() {
        return internalRenderManager != null && internalRenderManager.isBroadcasted();
    }

    public void removeRenderer(AsyncRenderer renderer) {
        if (internalRenderManager != null) {
            internalRenderManager.removeRenderer(renderer);
        }
    }

    public void requestRender(Renderable renderable) {
        if (internalRenderManager != null) {
            internalRenderManager.requestRender(renderable);
        }
    }

    public void setBroadcasted(boolean broadcasted) {
        if (internalRenderManager != null) {
            internalRenderManager.setBroadcasted(broadcasted);
        }
    }

    public static synchronized void setServletConfig(ServletConfig servletConfig) {
        if (internalRenderManager == null) {
            internalRenderManager = new InternalRenderManager(new ServletContextConfiguration("com.icesoft.faces.async.render", servletConfig.getServletContext()));
        }
    }

    public void setCorePoolSize(int corePoolSize) {
        internalRenderManager.setCorePoolSize(corePoolSize);
    }

    public void setMaxPoolSize(int maxPoolSize) {
        internalRenderManager.setMaxPoolSize(maxPoolSize);
    }

    public void setKeepAliveTime(long keepAliveTime) {
        internalRenderManager.setKeepAliveTime(keepAliveTime);
    }

    public void setRenderQueueCapacity(int renderQueueCapacity) {
        internalRenderManager.setRenderQueueCapacity(renderQueueCapacity);
    }

    ScheduledThreadPoolExecutor getScheduledService() {
        return internalRenderManager != null ? internalRenderManager.getScheduledService() : null;
    }

    void requestRender(AsyncRenderer renderer) {
        if (internalRenderManager != null) {
            internalRenderManager.requestRender(renderer);
        }
    }

    private static class InternalRenderManager
    extends RenderManager
    implements Disposable {
        private static final Log LOG = LogFactory.getLog((Class)(class$com$icesoft$faces$async$render$RenderManager$InternalRenderManager == null ? (class$com$icesoft$faces$async$render$RenderManager$InternalRenderManager = RenderManager.class$("com.icesoft.faces.async.render.RenderManager$InternalRenderManager")) : class$com$icesoft$faces$async$render$RenderManager$InternalRenderManager));
        private final RenderHub renderHub;
        private final BroadcastHub broadcastHub = new BroadcastHub();
        private final Map rendererGroupMap = Collections.synchronizedMap(new HashMap());
        private final ContextDestroyedListener shutdownListener = new ContextDestroyedListener(this);
        private boolean broadcasted;

        private InternalRenderManager(Configuration configuration) {
            this.renderHub = new RenderHub(configuration);
            this.setBroadcasted(configuration.getAttributeAsBoolean("broadcasted", false));
            ContextEventRepeater.addListener(this.shutdownListener);
            this.broadcastHub.setRenderManager(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Map map = this.rendererGroupMap;
            synchronized (map) {
                Iterator renderers = new ArrayList(this.rendererGroupMap.values()).iterator();
                while (renderers.hasNext()) {
                    AsyncRenderer renderer = (AsyncRenderer)renderers.next();
                    renderer.dispose();
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace((Object)("Renderer disposed: " + renderer));
                }
                this.rendererGroupMap.clear();
            }
            this.renderHub.dispose();
            LOG.debug((Object)"All renderers and render hub have been disposed.");
            ContextEventRepeater.removeListener(this.shutdownListener);
        }

        public DelayRenderer getDelayRenderer(String rendererName) {
            return (DelayRenderer)this.getRenderer(rendererName, 4);
        }

        public IntervalRenderer getIntervalRenderer(String rendererName) {
            return (IntervalRenderer)this.getRenderer(rendererName, 3);
        }

        public OnDemandRenderer getOnDemandRenderer(String rendererName) {
            return (OnDemandRenderer)this.getRenderer(rendererName, 2);
        }

        public AsyncRenderer getRenderer(String rendererName) {
            if (rendererName == null) {
                return null;
            }
            return (AsyncRenderer)this.rendererGroupMap.get(rendererName);
        }

        public boolean isBroadcasted() {
            return this.broadcasted;
        }

        public void removeRenderer(AsyncRenderer renderer) {
            if (renderer == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Renderer is null");
                }
            } else if (this.rendererGroupMap.remove(renderer.getName()) == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Renderer " + renderer.getName() + " not found"));
                }
            } else if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Renderer " + renderer.getName() + " removed"));
            }
        }

        public void requestRender(Renderable renderable) {
            this.renderHub.requestRender(renderable);
        }

        public void setBroadcasted(boolean broadcasted) {
            this.broadcasted = broadcasted;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.renderHub.setCorePoolSize(corePoolSize);
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.renderHub.setMaxPoolSize(maxPoolSize);
        }

        public void setKeepAliveTime(long keepAliveTime) {
            this.renderHub.setKeepAliveTime(keepAliveTime);
        }

        public void setRenderQueueCapacity(int renderQueueCapacity) {
            this.renderHub.setRenderQueueCapacity(renderQueueCapacity);
        }

        ScheduledThreadPoolExecutor getScheduledService() {
            return this.renderHub.getScheduledService();
        }

        void requestRender(AsyncRenderer renderer) {
            if (renderer == null) {
                return;
            }
            if (this.isBroadcasted() && renderer.isBroadcasted()) {
                this.broadcastHub.relayRenderRequest(renderer);
            }
        }

        private synchronized AsyncRenderer getRenderer(String name, int type) throws IllegalArgumentException {
            OnDemandRenderer renderer;
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("Illegal renderer name: " + name);
            }
            if (type < 1 || type > 4) {
                throw new IllegalArgumentException("Illegal renderer type: " + type);
            }
            if (this.rendererGroupMap.containsKey(name)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Existing renderer retrieved: " + name));
                }
                return (AsyncRenderer)this.rendererGroupMap.get(name);
            }
            switch (type) {
                case 2: {
                    renderer = new OnDemandRenderer();
                    break;
                }
                case 3: {
                    renderer = new IntervalRenderer();
                    break;
                }
                case 4: {
                    renderer = new DelayRenderer();
                    break;
                }
                default: {
                    renderer = null;
                }
            }
            if (renderer != null) {
                renderer.setBroadcasted(this.broadcasted);
                renderer.setName(name);
                this.rendererGroupMap.put(name, renderer);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("New renderer retrieved: " + name));
            }
            return renderer;
        }
    }
}

