/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.GroupAsyncRenderer;
import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.net.messaging.AbstractMessageHandler;
import com.icesoft.net.messaging.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RenderMessageHandler
extends AbstractMessageHandler {
    private static final Log LOG = LogFactory.getLog((Class)RenderMessageHandler.class);
    private RenderManager renderManager;

    public RenderMessageHandler(RenderManager renderManager) {
        this.renderManager = renderManager;
    }

    public void handle(Message message) {
        block9: {
            try {
                String rendererName = message.getStringProperty("rendererName");
                String command = message.getStringProperty("command");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Message received: " + rendererName + "," + command));
                }
                if (this.renderManager == null) {
                    String errMessage = "Render manager has not been set";
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)errMessage);
                    }
                    throw new IllegalStateException(errMessage);
                }
                GroupAsyncRenderer renderer = (GroupAsyncRenderer)this.renderManager.getRenderer(rendererName);
                if (renderer != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Requesting renderer via: " + renderer));
                    }
                    renderer.requestRender(false);
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Could not find name renderer " + rendererName));
                }
            }
            catch (Throwable throwable) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)"Problem processing message", throwable);
            }
        }
    }
}

