/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.util;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HalterDump {
    private UIComponent component;
    private ResponseWriter writer;
    private boolean halt = false;
    private boolean resume = true;
    private Node rootNode;
    private Node halter;
    private Node resumer;

    public HalterDump(ResponseWriter writer, UIComponent component, Node root) {
        this.component = component;
        this.writer = writer;
        this.rootNode = root;
    }

    public void streamWrite(Node halter) throws IOException {
        this.halter = halter;
        this.halt = false;
        this.dumpNode(this.rootNode);
    }

    public void dumpNode(Node node) throws IOException {
        if (this.halt) {
            return;
        }
        if (node.equals(this.halter)) {
            this.halt = true;
            this.resumer = this.halter;
            this.halter = null;
        }
        if (this.resume) {
            this.startNode(node);
        }
        if (this.halt) {
            this.resume = false;
            return;
        }
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node nextChildNode = children.item(i);
            this.dumpNode(nextChildNode);
        }
        if (node.equals(this.resumer)) {
            this.resume = true;
            this.halt = false;
        }
        if (this.halt) {
            this.resume = false;
            return;
        }
        if (this.resume) {
            this.endNode(node);
        }
    }

    private void startNode(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                break;
            }
            case 1: {
                String name = node.getNodeName();
                this.writer.startElement(node.getNodeName().toLowerCase(), this.component);
                NamedNodeMap attributes = node.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node current = attributes.item(i);
                    this.writer.writeAttribute(current.getNodeName(), (Object)current.getNodeValue(), current.getNodeName());
                }
                break;
            }
            case 3: {
                this.writer.writeText((Object)node.getNodeValue(), "text");
            }
        }
    }

    private void endNode(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                break;
            }
            case 1: {
                String name = node.getNodeName();
                this.writer.endElement(node.getNodeName().toLowerCase());
                break;
            }
        }
    }
}

