/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.webapp.http.common.ResponseHandler;
import com.icesoft.faces.webapp.http.common.Server;
import com.icesoft.faces.webapp.http.servlet.EnvironmentAdaptingException;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletRequestResponse;
import com.sun.enterprise.web.connector.grizzly.comet.CometContext;
import com.sun.enterprise.web.connector.grizzly.comet.CometEngine;
import com.sun.enterprise.web.connector.grizzly.comet.CometEvent;
import com.sun.enterprise.web.connector.grizzly.comet.CometHandler;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlassFishAdaptingServlet
implements PseudoServlet {
    private static final Log LOG = LogFactory.getLog((Class)GlassFishAdaptingServlet.class);
    private final Server server;
    private final String contextPath;

    public GlassFishAdaptingServlet(Server server, ServletContext servletContext) throws ServletException {
        this.server = server;
        try {
            this.contextPath = ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)servletContext, (Object[])null) + "/";
        }
        catch (NoSuchMethodException exception) {
            throw new EnvironmentAdaptingException("No such method: ServletContext.getContextPath", exception);
        }
        catch (IllegalAccessException exception) {
            throw new EnvironmentAdaptingException("Illegal access: ServletContext.getContextPath", exception);
        }
        catch (InvocationTargetException exception) {
            throw new EnvironmentAdaptingException("Invocation target: ServletContext.getContextPath", exception);
        }
        CometEngine.getEngine().register(this.contextPath).setExpirationDelay(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
        GlassFishRequestResponse requestResponse = new GlassFishRequestResponse(request, response);
        this.server.service(requestResponse);
        GlassFishRequestResponse glassFishRequestResponse = requestResponse;
        synchronized (glassFishRequestResponse) {
            if (!requestResponse.isDone()) {
                requestResponse.park();
                try {
                    CometEngine.getEngine().register(this.contextPath).addCometHandler((CometHandler)requestResponse);
                }
                catch (IllegalStateException exception) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("\r\n\r\nFailed to add Comet handler: \r\n    Exception message: " + exception.getMessage() + "\r\n" + "    Exception cause: " + exception.getCause() + "\r\n\r\n" + "To enable GlassFish ARP, please set the " + "cometSupport property to true in the \r\n" + "domain's config/domain.xml for the " + "http-listener listening to port " + request.getServerPort() + ".\r\n"));
                    }
                    throw new EnvironmentAdaptingException(exception);
                }
            }
        }
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private class GlassFishRequestResponse
    extends ServletRequestResponse
    implements CometHandler {
        private boolean parked;
        private boolean done;

        public GlassFishRequestResponse(HttpServletRequest request, HttpServletResponse response) throws Exception {
            super(request, response);
            this.parked = false;
            this.done = false;
        }

        public void attach(Object object) {
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean isParked() {
            return this.parked;
        }

        public void onEvent(CometEvent event) throws IOException {
        }

        public void onInitialize(CometEvent event) throws IOException {
        }

        public void onTerminate(CometEvent event) throws IOException {
        }

        public void onInterrupt(CometEvent event) throws IOException {
        }

        public void park() {
            this.parked = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void respondWith(ResponseHandler handler) throws Exception {
            GlassFishRequestResponse glassFishRequestResponse = this;
            synchronized (glassFishRequestResponse) {
                if (!this.isParked()) {
                    handler.respond(this);
                    this.done = true;
                } else {
                    CometContext cometContext = CometEngine.getEngine().register(GlassFishAdaptingServlet.this.contextPath);
                    int count = 0;
                    while (!cometContext.isActive((CometHandler)this)) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException exception) {
                            // empty catch block
                        }
                        if (count++ <= 10) continue;
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug((Object)"cometContext.isActive failed");
                        break;
                    }
                    if (cometContext.isActive((CometHandler)this)) {
                        handler.respond(this);
                        cometContext.resumeCometHandler((CometHandler)this);
                        this.unpark();
                    }
                }
            }
        }

        public void unpark() {
            this.parked = false;
        }
    }
}

