/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.chartData;

import java.awt.Paint;
import org.krysalis.jcharts.chartData.interfaces.IDataSet;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;

public class DataSet
implements IDataSet,
HTMLTestable {
    private ChartTypeProperties chartTypeProperties;
    protected double[][] data;
    protected String[] legendLabels;
    protected Paint[] paints;

    public DataSet(double[][] dArray, String[] stringArray, Paint[] paintArray, ChartTypeProperties chartTypeProperties) {
        this.data = dArray;
        this.legendLabels = stringArray;
        this.paints = paintArray;
        this.chartTypeProperties = chartTypeProperties;
    }

    public final String getLegendLabel(int n) {
        if (this.legendLabels == null) {
            return null;
        }
        return this.legendLabels[n];
    }

    public int getNumberOfLegendLabels() {
        if (this.legendLabels == null) {
            return 0;
        }
        return this.legendLabels.length;
    }

    public Paint getPaint(int n) {
        return this.paints[n];
    }

    public ChartTypeProperties getChartTypeProperties() {
        return this.chartTypeProperties;
    }

    public int getNumberOfDataItems() {
        return this.data[0].length;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        hTMLGenerator.addTableRow("data", HTMLGenerator.arrayToString(this.data));
        if (this.legendLabels != null) {
            hTMLGenerator.addTableRow("legendLabels", HTMLGenerator.arrayToString(this.legendLabels));
        }
        hTMLGenerator.addTableRow("paints", HTMLGenerator.arrayToString(this.paints));
        hTMLGenerator.propertiesTableEnd();
        hTMLGenerator.chartTableRowStart();
        this.chartTypeProperties.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
    }
}

