/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.chartData;

import java.awt.Paint;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.DataSet;
import org.krysalis.jcharts.chartData.interfaces.IRadarChartDataSet;
import org.krysalis.jcharts.properties.RadarChartProperties;
import org.krysalis.jcharts.test.HTMLGenerator;

public final class RadarChartDataSet
extends DataSet
implements IRadarChartDataSet {
    private String chartTitle;
    private String[] axisLabels;

    public RadarChartDataSet(String string, double[][] dArray, String[] stringArray, Paint[] paintArray, String[] stringArray2, RadarChartProperties radarChartProperties) throws ChartDataException {
        super(dArray, stringArray, paintArray, radarChartProperties);
        this.validateData(dArray, stringArray, stringArray2, paintArray);
        this.chartTitle = string;
        this.axisLabels = stringArray2;
    }

    private void validateData(double[][] dArray, String[] stringArray, String[] stringArray2, Paint[] paintArray) throws ChartDataException {
        if (stringArray != null && dArray.length != stringArray.length) {
            throw new ChartDataException("There is not an one to one mapping of 'legend labels' to 'data items'.");
        }
        if (dArray.length != paintArray.length) {
            throw new ChartDataException("There is not an one to one mapping of 'Paint' Implementations to 'data items'.");
        }
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i].length == dArray[0].length) continue;
            throw new ChartDataException("All data items should contain an equal number of values.");
        }
        if (dArray.length > 0 && stringArray2.length != dArray[0].length) {
            throw new ChartDataException("There is not a one to one mapping of axis labels to values per 'data item'.");
        }
    }

    public String getChartTitle() {
        return this.chartTitle;
    }

    public final double getValue(int n, int n2) throws ArrayIndexOutOfBoundsException {
        return this.data[n][n2];
    }

    public final int getNumberOfDataSets() {
        return this.data.length;
    }

    public final int getDataSetSize() {
        if (this.data.length == 0) {
            return 0;
        }
        return this.data[0].length;
    }

    public String getAxisLabel(int n) {
        return this.axisLabels[n];
    }

    public int getNumberOfAxisLabels() {
        if (this.axisLabels != null) {
            return this.axisLabels.length;
        }
        return 0;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        super.toHTML(hTMLGenerator);
    }
}

