/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.FileUploadTestCase;
import org.apache.commons.fileupload.MockHttpServletRequest;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class ProgressListenerTest
extends FileUploadTestCase {
    public void testProgressListener() throws Exception {
        int NUM_ITEMS = 512;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int i = 0;
        while (i < 512) {
            String header = "-----1234\r\nContent-Disposition: form-data; name=\"field" + (i + 1) + "\"\r\n" + "\r\n";
            baos.write(header.getBytes("US-ASCII"));
            int j = 0;
            while (j < 16384 + i) {
                baos.write((byte)j);
                ++j;
            }
            baos.write("\r\n".getBytes("US-ASCII"));
            ++i;
        }
        baos.write("-----1234--\r\n".getBytes("US-ASCII"));
        byte[] contents = baos.toByteArray();
        MockHttpServletRequest request = new MockHttpServletRequest(contents, "multipart/form-data; boundary=---1234");
        this.runTest(512, contents.length, request);
        request = new MockHttpServletRequest(contents, "multipart/form-data; boundary=---1234"){

            public int getContentLength() {
                return -1;
            }
        };
        this.runTest(512, contents.length, request);
    }

    private void runTest(int NUM_ITEMS, long pContentLength, MockHttpServletRequest request) throws FileUploadException, IOException {
        ServletFileUpload upload = new ServletFileUpload();
        ProgressListenerImpl listener = new ProgressListenerImpl(pContentLength, NUM_ITEMS);
        upload.setProgressListener(listener);
        FileItemIterator iter = upload.getItemIterator(request);
        int i = 0;
        while (i < NUM_ITEMS) {
            FileItemStream stream = iter.next();
            InputStream istream = stream.openStream();
            int j = 0;
            while (j < 16384 + i) {
                byte b1 = (byte)j;
                byte b2 = (byte)istream.read();
                if (b1 != b2) {
                    Assert.fail((String)("Expected " + b1 + ", got " + b2));
                }
                ++j;
            }
            Assert.assertEquals((int)-1, (int)istream.read());
            ++i;
        }
        Assert.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
        listener.checkFinished();
    }

    private class ProgressListenerImpl
    implements ProgressListener {
        private final long expectedContentLength;
        private final int expectedItems;
        private Long bytesRead;
        private Integer items;

        ProgressListenerImpl(long pContentLength, int pItems) {
            this.expectedContentLength = pContentLength;
            this.expectedItems = pItems;
        }

        public void update(long pBytesRead, long pContentLength, int pItems) {
            Assert.assertTrue((pBytesRead >= 0L && pBytesRead <= this.expectedContentLength ? 1 : 0) != 0);
            Assert.assertTrue((pContentLength == -1L || pContentLength == this.expectedContentLength ? 1 : 0) != 0);
            Assert.assertTrue((pItems >= 0 && pItems <= this.expectedItems ? 1 : 0) != 0);
            Assert.assertTrue((this.bytesRead == null || pBytesRead >= this.bytesRead ? 1 : 0) != 0);
            this.bytesRead = new Long(pBytesRead);
            Assert.assertTrue((this.items == null || pItems >= this.items ? 1 : 0) != 0);
            this.items = new Integer(pItems);
        }

        void checkFinished() {
            Assert.assertEquals((long)this.expectedContentLength, (long)this.bytesRead);
            Assert.assertEquals((int)this.expectedItems, (int)this.items);
        }
    }
}

