/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.jsfcl.data;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.BasicTableDataSorter;
import com.sun.data.provider.impl.CachedRowSetDataProvider;
import com.sun.data.provider.impl.FieldKeySortCriteria;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.sql.rowset.CachedRowSet;

public class CachedRowSetSortableDataModel
extends DataModel {
    private static Logger log = Logger.getLogger("com.icesoft.faces.component.jsfcl.data.CachedRowSetSortableDataModel");
    private boolean ascending;
    private int index = -1;
    private TreeMap[] rows = null;
    private String sort;
    private CachedRowSet cachedRowSet;
    private SortCriteria[] sortCriteria;

    public CachedRowSetSortableDataModel() {
        this(null);
    }

    public CachedRowSetSortableDataModel(CachedRowSet cachedRowSet) {
        this.setWrappedData(cachedRowSet);
        log.log(Level.FINEST, "cachedRow Model init");
    }

    public int getRowCount() {
        log.log(Level.FINEST, " cachedRow Model rowCount=");
        if (this.cachedRowSet == null) {
            return -1;
        }
        return this.rows.length;
    }

    public Object getWrappedData() {
        log.log(Level.FINEST, "getWrapperData");
        return this.cachedRowSet;
    }

    public boolean isRowAvailable() {
        if (this.cachedRowSet == null || this.rows == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.rows.length;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.cachedRowSet = null;
            this.rows = null;
            this.setRowIndex(-1);
        } else if (data instanceof CachedRowSet) {
            this.cachedRowSet = (CachedRowSet)data;
            this.rows = this.getSortedDataCache();
        } else {
            log.log(Level.FINEST, "wrong data = " + data.getClass().getName());
            throw new IllegalArgumentException();
        }
    }

    public boolean isAscending() {
        log.log(Level.FINEST, " ascending = " + this.ascending);
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        log.log(Level.FINEST, "set ascending = " + ascending);
        this.ascending = ascending;
    }

    public String getSort() {
        if (this.sort != null) {
            log.log(Level.FINEST, "call getSort criteria=" + this.sort);
        }
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
        if (sort != null) {
            FieldKey fieldKey = new FieldKey(this.getSort());
            FieldKeySortCriteria oneCriteria = new FieldKeySortCriteria(fieldKey, this.isAscending());
            this.sortCriteria = new SortCriteria[]{oneCriteria};
            this.getSortedDataCache();
        }
        log.log(Level.FINEST, "new criteria =" + sort);
    }

    public void setSortCriteria(SortCriteria[] sortCriteria) {
        this.sortCriteria = sortCriteria;
        log.log(Level.FINEST, "set sort criteria");
    }

    public SortCriteria[] getSortCriteria() {
        if (this.sortCriteria == null) {
            FieldKey fieldKey = new FieldKey(this.getSort());
            FieldKeySortCriteria oneCriteria = new FieldKeySortCriteria(fieldKey, this.isAscending());
            this.sortCriteria = new SortCriteria[]{oneCriteria};
        }
        log.log(Level.FINEST, "get sort criteria");
        return this.sortCriteria;
    }

    private RowKey[] getSortedRowKeys(TableDataProvider tableDataProvider, RowKey[] rowKeys) {
        BasicTableDataSorter sorter = new BasicTableDataSorter();
        sorter.setSortCriteria(this.getSortCriteria());
        RowKey[] sortedRowKeys = sorter.sort(tableDataProvider, rowKeys);
        return sortedRowKeys;
    }

    public Object getRowData() {
        if (this.cachedRowSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.rows[this.index];
    }

    private TreeMap[] getSortedDataCache() {
        CachedRowSetDataProvider tableDataProvider = new CachedRowSetDataProvider(this.cachedRowSet);
        if (tableDataProvider.getRowCount() != -1) {
            FieldKey[] fieldKeys = tableDataProvider.getFieldKeys();
            for (int j = 0; j < fieldKeys.length; ++j) {
                log.log(Level.FINEST, "field key=" + fieldKeys[j].getDisplayName() + "field id=" + fieldKeys[j].getFieldId());
            }
            if (this.getSort() == null) {
                this.setSort(fieldKeys[0].getFieldId());
                this.ascending = true;
            }
            RowKey[] rowKeys = tableDataProvider.getRowKeys(Integer.MAX_VALUE, null);
            rowKeys = this.getSortedRowKeys((TableDataProvider)tableDataProvider, rowKeys);
            this.rows = new TreeMap[rowKeys.length];
            for (int j = 0; j < rowKeys.length; ++j) {
                TreeMap<String, Object> row = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
                for (int i = 0; i < fieldKeys.length; ++i) {
                    row.put(fieldKeys[i].getFieldId(), tableDataProvider.getValue(fieldKeys[i], rowKeys[j]));
                }
                this.rows[j] = row;
            }
        } else {
            log.log(Level.FINEST, " RowSet has no data" + tableDataProvider.getRowCount());
        }
        log.log(Level.FINEST, "dataCached rows=" + this.rows.length);
        return this.rows;
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.cachedRowSet == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }
}

