/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Callable;
import edu.emory.mathcs.backport.java.util.concurrent.CompletionService;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;

public class ExecutorCompletionService
implements CompletionService {
    private final Executor executor;
    private final BlockingQueue completionQueue;

    public ExecutorCompletionService(Executor executor) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = new LinkedBlockingQueue();
    }

    public ExecutorCompletionService(Executor executor, BlockingQueue completionQueue) {
        if (executor == null || completionQueue == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = completionQueue;
    }

    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture f = new QueueingFuture(task);
        this.executor.execute(f);
        return f;
    }

    public Future submit(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        QueueingFuture f = new QueueingFuture(task, result);
        this.executor.execute(f);
        return f;
    }

    public Future take() throws InterruptedException {
        return (Future)this.completionQueue.take();
    }

    public Future poll() {
        return (Future)this.completionQueue.poll();
    }

    public Future poll(long timeout, TimeUnit unit) throws InterruptedException {
        return (Future)this.completionQueue.poll(timeout, unit);
    }

    private class QueueingFuture
    extends FutureTask {
        QueueingFuture(Callable c) {
            super(c);
        }

        QueueingFuture(Runnable t, Object r) {
            super(t, r);
        }

        protected void done() {
            ExecutorCompletionService.this.completionQueue.add(this);
        }
    }
}

